/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import org.infinispan.marshall.core.GlobalMarshaller;

final class BytesObjectInput
implements ObjectInput {
    final byte[] bytes;
    final GlobalMarshaller marshaller;
    int pos;
    int offset;

    private BytesObjectInput(byte[] bytes, int offset, GlobalMarshaller marshaller) {
        this.bytes = bytes;
        this.pos = offset;
        this.offset = offset;
        this.marshaller = marshaller;
    }

    static BytesObjectInput from(byte[] bytes, GlobalMarshaller marshaller) {
        return BytesObjectInput.from(bytes, 0, marshaller);
    }

    static BytesObjectInput from(byte[] bytes, int offset, GlobalMarshaller marshaller) {
        return new BytesObjectInput(bytes, offset, marshaller);
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.marshaller.readNullableObject(this);
    }

    @Override
    public int read() {
        if (this.pos >= this.bytes.length) {
            return -1;
        }
        return this.bytes[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.pos >= this.bytes.length) {
            return -1;
        }
        if (this.pos + len >= this.bytes.length) {
            len = this.bytes.length - this.pos;
        }
        System.arraycopy(this.bytes, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if (n > 0L) {
            long skip = this.bytes.length - this.pos;
            if (skip > n) {
                skip = n;
            }
            this.pos = (int)((long)this.pos + skip);
            return skip;
        }
        int idx = Math.min(this.bytes.length, this.pos);
        long skip = (long)idx + n;
        this.pos = (int)Math.max(skip, (long)this.offset);
        return skip;
    }

    @Override
    public int available() {
        return this.bytes.length - this.pos;
    }

    @Override
    public void close() {
    }

    @Override
    public void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        System.arraycopy(this.bytes, this.pos, b, off, len);
        this.pos += len;
    }

    @Override
    public int skipBytes(int n) {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws EOFException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws EOFException {
        if (this.pos >= this.bytes.length) {
            throw new EOFException();
        }
        return this.bytes[this.pos++];
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() {
        short v = (short)(this.bytes[this.pos] << 8 | this.bytes[this.pos + 1] & 0xFF);
        this.pos += 2;
        return v;
    }

    @Override
    public int readUnsignedShort() {
        int v = (this.bytes[this.pos] & 0xFF) << 8 | this.bytes[this.pos + 1] & 0xFF;
        this.pos += 2;
        return v;
    }

    @Override
    public char readChar() {
        char v = (char)(this.bytes[this.pos] << 8 | this.bytes[this.pos + 1] & 0xFF);
        this.pos += 2;
        return v;
    }

    @Override
    public int readInt() {
        int v = this.bytes[this.pos] << 24 | (this.bytes[this.pos + 1] & 0xFF) << 16 | (this.bytes[this.pos + 2] & 0xFF) << 8 | this.bytes[this.pos + 3] & 0xFF;
        this.pos += 4;
        return v;
    }

    @Override
    public long readLong() {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() {
        return null;
    }

    @Override
    public String readUTF() {
        int c;
        int count;
        int utflen = this.readInt();
        byte[] bytearr = this.bytes;
        char[] chararr = new char[utflen];
        utflen = this.pos + utflen;
        int chararr_count = 0;
        for (count = this.pos; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new RuntimeException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new RuntimeException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new RuntimeException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new RuntimeException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new RuntimeException("malformed input around byte " + count);
        }
        this.pos = count;
        return new String(chararr, 0, chararr_count);
    }

    String readString() throws EOFException {
        byte mark = this.readByte();
        switch (mark) {
            case 0: {
                return "";
            }
            case 1: {
                byte size = this.readByte();
                String str = new String(this.bytes, 0, this.pos, (int)size);
                this.pos += size;
                return str;
            }
            case 2: {
                return this.readUTF();
            }
        }
        throw new RuntimeException("Unknown marker(String). mark=" + mark);
    }
}

