/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.List;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.AnnotatedTypeLoader;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployerEnvironmentFactory;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.executor.IterativeWorkerTaskFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.util.collections.SetMultimap;

public class ConcurrentBeanDeployer
extends BeanDeployer {
    private final ExecutorServices executor;

    public ConcurrentBeanDeployer(BeanManagerImpl manager, ServiceRegistry services) {
        super(manager, services, BeanDeployerEnvironmentFactory.newConcurrentEnvironment(manager));
        this.executor = (ExecutorServices)services.get(ExecutorServices.class);
    }

    @Override
    public BeanDeployer addClasses(Iterable<String> c) {
        final AnnotatedTypeLoader loader = this.createAnnotatedTypeLoader();
        this.executor.invokeAllAndCheckForExceptions((ExecutorServices.TaskFactory)new IterativeWorkerTaskFactory<String>(c){

            @Override
            protected void doWork(String className) {
                ConcurrentBeanDeployer.this.addClass(className, loader);
            }
        });
        return this;
    }

    @Override
    public void createClassBeans() {
        final SetMultimap<Class<?>, SlimAnnotatedType<?>> otherWeldClasses = SetMultimap.newConcurrentSetMultimap();
        this.executor.invokeAllAndCheckForExceptions((ExecutorServices.TaskFactory)new IterativeWorkerTaskFactory<SlimAnnotatedTypeContext<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()){

            @Override
            protected void doWork(SlimAnnotatedTypeContext<?> ctx) {
                ConcurrentBeanDeployer.this.createClassBean(ctx.getAnnotatedType(), otherWeldClasses);
            }
        });
        this.ejbSupport.createSessionBeans((BeanDeployerEnvironment)this.getEnvironment(), otherWeldClasses, this.getManager());
    }

    @Override
    public void createProducersAndObservers() {
        this.executor.invokeAllAndCheckForExceptions((ExecutorServices.TaskFactory)new IterativeWorkerTaskFactory<AbstractClassBean<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans()){

            @Override
            protected void doWork(AbstractClassBean<?> bean) {
                ConcurrentBeanDeployer.this.createObserversProducersDisposers(bean);
            }
        });
    }

    @Override
    public void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        this.executor.invokeAllAndCheckForExceptions((ExecutorServices.TaskFactory)new AfterBeanDiscoveryInitializerFactory((Iterable<? extends Bean<?>>)beanList));
    }

    @Override
    public AbstractBeanDeployer<BeanDeployerEnvironment> initializeBeans() {
        this.executor.invokeAllAndCheckForExceptions((ExecutorServices.TaskFactory)new IterativeWorkerTaskFactory<RIBean<?>>(((BeanDeployerEnvironment)this.getEnvironment()).getBeans()){

            @Override
            protected void doWork(RIBean<?> bean) {
                bean.initialize((BeanDeployerEnvironment)ConcurrentBeanDeployer.this.getEnvironment());
            }
        });
        return this;
    }

    private static class AfterBeanDiscoveryInitializerFactory
    extends IterativeWorkerTaskFactory<Bean<?>> {
        public AfterBeanDiscoveryInitializerFactory(Iterable<? extends Bean<?>> iterable) {
            super(iterable);
        }

        @Override
        protected void doWork(Bean<?> bean) {
            if (bean instanceof RIBean) {
                ((RIBean)bean).initializeAfterBeanDiscovery();
            }
        }
    }
}

