/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.http;

import org.picketlink.config.http.AuthenticationConfiguration;
import org.picketlink.config.http.AuthenticationMethodConfigurationBuilder;
import org.picketlink.config.http.AuthenticationSchemeConfiguration;
import org.picketlink.config.http.BasicAuthenticationConfigurationBuilder;
import org.picketlink.config.http.CustomAuthenticationConfigurationBuilder;
import org.picketlink.config.http.DigestAuthenticationConfigurationBuilder;
import org.picketlink.config.http.FormAuthenticationConfigurationBuilder;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.config.http.PathConfigurationBuilder;
import org.picketlink.config.http.TokenAuthenticationConfigurationBuilder;
import org.picketlink.config.http.X509AuthenticationConfigurationBuilder;
import org.picketlink.http.authentication.HttpAuthenticationScheme;

public class AuthenticationConfigurationBuilder {
    private final PathConfigurationBuilder parentBuilder;
    private AuthenticationMethodConfigurationBuilder authenticationMethodConfigurationBuilder;

    public AuthenticationConfigurationBuilder(PathConfigurationBuilder parentBuilder) {
        this.parentBuilder = parentBuilder;
    }

    public FormAuthenticationConfigurationBuilder form() {
        this.authenticationMethodConfigurationBuilder = new FormAuthenticationConfigurationBuilder(this.parentBuilder);
        return (FormAuthenticationConfigurationBuilder)this.authenticationMethodConfigurationBuilder;
    }

    public BasicAuthenticationConfigurationBuilder basic() {
        this.authenticationMethodConfigurationBuilder = new BasicAuthenticationConfigurationBuilder(this.parentBuilder);
        return (BasicAuthenticationConfigurationBuilder)this.authenticationMethodConfigurationBuilder;
    }

    public DigestAuthenticationConfigurationBuilder digest() {
        this.authenticationMethodConfigurationBuilder = new DigestAuthenticationConfigurationBuilder(this.parentBuilder);
        return (DigestAuthenticationConfigurationBuilder)this.authenticationMethodConfigurationBuilder;
    }

    public X509AuthenticationConfigurationBuilder x509() {
        this.authenticationMethodConfigurationBuilder = new X509AuthenticationConfigurationBuilder(this.parentBuilder);
        return (X509AuthenticationConfigurationBuilder)this.authenticationMethodConfigurationBuilder;
    }

    public TokenAuthenticationConfigurationBuilder token() {
        this.authenticationMethodConfigurationBuilder = new TokenAuthenticationConfigurationBuilder(this.parentBuilder);
        return (TokenAuthenticationConfigurationBuilder)this.authenticationMethodConfigurationBuilder;
    }

    public CustomAuthenticationConfigurationBuilder scheme(Class<? extends HttpAuthenticationScheme> schemeType) {
        this.authenticationMethodConfigurationBuilder = new CustomAuthenticationConfigurationBuilder(schemeType, this.parentBuilder);
        return (CustomAuthenticationConfigurationBuilder)this.authenticationMethodConfigurationBuilder;
    }

    AuthenticationConfiguration create(PathConfiguration pathConfiguration) {
        AuthenticationConfiguration authenticationConfiguration = new AuthenticationConfiguration(pathConfiguration);
        AuthenticationSchemeConfiguration authenticationMethodConfiguration = null;
        if (this.authenticationMethodConfigurationBuilder != null) {
            authenticationMethodConfiguration = (AuthenticationSchemeConfiguration)this.authenticationMethodConfigurationBuilder.create(authenticationConfiguration);
        }
        authenticationConfiguration.setAuthenticationSchemeConfiguration(authenticationMethodConfiguration);
        return authenticationConfiguration;
    }
}

