/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.jboss.ejb3;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.jboss.ejb3.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.parser.jboss.ejb3.Attribute;
import org.jboss.metadata.ejb.parser.jboss.ejb3.Element;
import org.jboss.metadata.ejb.parser.jboss.ejb3.JBossAssemblyDescriptorMetaDataParser;
import org.jboss.metadata.ejb.parser.jboss.ejb3.JBossEnterpriseBeansMetaDataParser;
import org.jboss.metadata.ejb.parser.jboss.ejb3.Namespace;
import org.jboss.metadata.ejb.parser.spec.AbstractEjbJarMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarNamespaceMapping;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;

public class JBossEjb3MetaDataParser
extends AbstractEjbJarMetaDataParser {
    private final Map<String, AbstractMetaDataParser<?>> parsers;

    public JBossEjb3MetaDataParser(Map<String, AbstractMetaDataParser<?>> parsers) {
        this.parsers = parsers;
    }

    @Override
    public EjbJarMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        throw new UnsupportedOperationException("org.jboss.metadata.ejb.parser.jboss.ejb3.JBossEjb3MetaDataParser.parse");
    }

    public EjbJarMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info) throws XMLStreamException {
        return this.parse(reader, info, PropertyReplacers.noop());
    }

    public EjbJarMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info, PropertyReplacer propertyReplacer) throws XMLStreamException {
        String schemaLocation;
        String dtdLocation;
        reader.require(7, null, null);
        EjbJarVersion ejbJarVersion = null;
        boolean dtd = false;
        while (reader.hasNext() && reader.next() != 1) {
            if (reader.getEventType() != 11) continue;
            dtd = true;
        }
        if (dtd && (dtdLocation = info.getSystemID()) != null) {
            ejbJarVersion = EjbJarNamespaceMapping.getEjbJarVersion(dtdLocation);
        }
        if (ejbJarVersion == null && (schemaLocation = JBossEjb3MetaDataParser.readSchemaLocation((XMLStreamReader)reader)) != null) {
            ejbJarVersion = EjbJarNamespaceMapping.getEjbJarVersion(schemaLocation);
        }
        if (ejbJarVersion == null) {
            ejbJarVersion = JBossEjb3MetaDataParser.readVersionAttribute(reader);
        }
        if (ejbJarVersion == null) {
            ejbJarVersion = EjbJarVersion.EJB_3_2;
        }
        if (ejbJarVersion != EjbJarVersion.EJB_3_1 && ejbJarVersion != EjbJarVersion.EJB_3_2) {
            throw new UnsupportedOperationException("Only EJB 3.1 or 3.2 descriptor is supported, found " + (Object)((Object)ejbJarVersion));
        }
        EjbJarMetaData metaData = new EjbJarMetaData(ejbJarVersion);
        this.processAttributes(metaData, reader);
        this.processElements(metaData, reader, propertyReplacer);
        return metaData;
    }

    private AssemblyDescriptorMetaData parseAssemblyDescriptor(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return (AssemblyDescriptorMetaData)new JBossAssemblyDescriptorMetaDataParser(this.parsers).parse(reader, propertyReplacer);
    }

    @Override
    protected void processAttribute(EjbJarMetaData metaData, XMLStreamReader reader, int i) throws XMLStreamException {
        String value = reader.getAttributeValue(i);
        if (JBossEjb3MetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) {
            return;
        }
        Attribute attr = Attribute.forName(reader.getAttributeLocalName(i));
        switch (attr) {
            case IMPL_VERSION: {
                break;
            }
            default: {
                super.processAttribute(metaData, reader, i);
            }
        }
    }

    @Override
    protected void processElement(EjbJarMetaData metaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        Element element = Element.forName(reader.getLocalName());
        block0 : switch (namespace) {
            case JBOSS: {
                switch (element) {
                    case ENTERPRISE_BEANS: {
                        metaData.setEnterpriseBeans(this.parseEnterpriseBeans(reader, metaData.getEjbJarVersion(), propertyReplacer));
                        break block0;
                    }
                    case DISTINCT_NAME: {
                        String val = JBossEjb3MetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                        metaData.setDistinctName(val);
                        break block0;
                    }
                }
                super.processElement(metaData, reader, propertyReplacer);
                break;
            }
            case SPEC: 
            case SPEC_7_0: {
                switch (element) {
                    case ASSEMBLY_DESCRIPTOR: {
                        metaData.setAssemblyDescriptor(this.parseAssemblyDescriptor(reader, propertyReplacer));
                        break block0;
                    }
                }
                super.processElement(metaData, reader, propertyReplacer);
                break;
            }
            default: {
                throw JBossEjb3MetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private JBossEnterpriseBeansMetaData parseEnterpriseBeans(XMLStreamReader reader, EjbJarVersion ejbJarVersion, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return new JBossEnterpriseBeansMetaDataParser(ejbJarVersion).parse(reader, propertyReplacer);
    }
}

