/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.picketlink.federation.service.KeyStoreProviderService;

public class KeyService
implements Service<KeyService> {
    private static final String SERVICE_NAME = "KeyService";
    private final String keyName;
    private final InjectedValue<KeyStoreProviderService> keyStoreProviderService = new InjectedValue();
    private final String host;

    public KeyService(String keyName, String host) {
        this.keyName = keyName;
        this.host = host;
    }

    public static ServiceName createServiceName(String federationAlias, String keyName) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, federationAlias + ".keystore." + keyName});
    }

    public KeyService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        KeyStoreProviderService keyStoreProviderService = (KeyStoreProviderService)this.getKeyStoreProviderService().getValue();
        keyStoreProviderService.addKey(this.keyName, this.host);
    }

    public void stop(StopContext context) {
        KeyStoreProviderService keyStoreProviderService = (KeyStoreProviderService)this.getKeyStoreProviderService().getValue();
        keyStoreProviderService.removeKey(this.keyName);
        context.getController().setMode(ServiceController.Mode.REMOVE);
    }

    public InjectedValue<KeyStoreProviderService> getKeyStoreProviderService() {
        return this.keyStoreProviderService;
    }
}

