/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal.mappers;

import java.util.ArrayList;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.jpa.annotations.PermissionOperation;
import org.picketlink.idm.jpa.annotations.PermissionResourceClass;
import org.picketlink.idm.jpa.annotations.PermissionResourceIdentifier;
import org.picketlink.idm.jpa.annotations.entity.PermissionManaged;
import org.picketlink.idm.jpa.internal.mappers.AbstractModelMapper;
import org.picketlink.idm.jpa.internal.mappers.EntityMapping;
import org.picketlink.idm.permission.Permission;

public class PermissionMapper
extends AbstractModelMapper {
    @Override
    protected List<EntityMapping> doCreateMapping(Class<?> entityType) throws SecurityConfigurationException {
        ArrayList<EntityMapping> mappings = new ArrayList<EntityMapping>();
        PermissionManaged identityManaged = entityType.getAnnotation(PermissionManaged.class);
        Class[] resourceClasses = identityManaged.resourceClasses();
        if (resourceClasses.length > 0) {
            for (Class resourceClass : resourceClasses) {
                mappings.add(this.createEntityMapping(entityType, resourceClass));
            }
        } else {
            mappings.add(this.createEntityMapping(entityType, Object.class));
        }
        return mappings;
    }

    private EntityMapping createEntityMapping(Class<?> entityType, Class<?> resourceClass) {
        EntityMapping mapping = new EntityMapping(resourceClass);
        mapping.addOwnerProperty(entityType);
        Property resourceClassProperty = this.getAnnotatedProperty(PermissionResourceClass.class, entityType);
        if (resourceClassProperty == null) {
            throw IDMMessages.MESSAGES.configJpaStoreRequiredMappingAnnotation(entityType, PermissionResourceClass.class);
        }
        mapping.addNotNullMappedProperty(resourceClassProperty);
        Property resourceIdentifierProperty = this.getAnnotatedProperty(PermissionResourceIdentifier.class, entityType);
        if (resourceIdentifierProperty == null) {
            throw IDMMessages.MESSAGES.configJpaStoreRequiredMappingAnnotation(entityType, PermissionResourceIdentifier.class);
        }
        mapping.addProperty(this.getNamedProperty("resourceIdentifier", Permission.class), resourceIdentifierProperty);
        Property operationProperty = this.getAnnotatedProperty(PermissionOperation.class, entityType);
        if (operationProperty == null) {
            throw IDMMessages.MESSAGES.configJpaStoreRequiredMappingAnnotation(entityType, PermissionOperation.class);
        }
        mapping.addProperty(this.getNamedProperty("operation", Permission.class), operationProperty);
        return mapping;
    }

    @Override
    public boolean supports(Class<?> entityType) {
        return entityType.isAnnotationPresent(PermissionManaged.class);
    }
}

