/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ProxyOperationExecutor;

enum ProxyOperation implements Operation<ModClusterServiceMBean>,
UnaryOperator<SimpleOperationDefinitionBuilder>
{
    ADD_PROXY("add-proxy"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setParameters(new AttributeDefinition[]{ProxyOperationExecutor.HOST, ProxyOperationExecutor.PORT}).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF);
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) throws OperationFailedException {
            String host = ProxyOperationExecutor.HOST.resolveModelAttribute(expressionResolver, operation).asString();
            int port = ProxyOperationExecutor.PORT.resolveModelAttribute(expressionResolver, operation).asInt();
            service.addProxy(host, port);
            return null;
        }
    }
    ,
    REMOVE_PROXY("remove-proxy"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setParameters(new AttributeDefinition[]{ProxyOperationExecutor.HOST, ProxyOperationExecutor.PORT}).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF);
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) throws OperationFailedException {
            String host = ProxyOperationExecutor.HOST.resolveModelAttribute(expressionResolver, operation).asString();
            int port = ProxyOperationExecutor.PORT.resolveModelAttribute(expressionResolver, operation).asInt();
            service.removeProxy(host, port);
            return null;
        }
    }
    ,
    READ_PROXIES_INFO("read-proxies-info"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setReadOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF);
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) {
            Map map = service.getProxyInfo();
            if (!map.isEmpty()) {
                ModelNode result = new ModelNode();
                for (Map.Entry entry : map.entrySet()) {
                    result.add(((InetSocketAddress)entry.getKey()).getHostName() + ":" + ((InetSocketAddress)entry.getKey()).getPort());
                    if (entry.getValue() == null) {
                        result.add();
                        continue;
                    }
                    result.add((String)entry.getValue());
                }
                return new ModelNode().set(result);
            }
            return null;
        }
    }
    ,
    LIST_PROXIES("list-proxies"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setReadOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF);
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) {
            Map map = service.getProxyInfo();
            if (!map.isEmpty()) {
                InetSocketAddress[] addresses;
                ModelNode result = new ModelNode();
                for (InetSocketAddress address : addresses = map.keySet().toArray(new InetSocketAddress[0])) {
                    result.add(address.getHostName() + ":" + address.getPort());
                }
                return new ModelNode().set(result);
            }
            return null;
        }
    }
    ,
    READ_PROXIES_CONFIGURATION("read-proxies-configuration"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setReadOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF);
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) {
            Map map = service.getProxyConfiguration();
            if (!map.isEmpty()) {
                ModelNode result = new ModelNode();
                for (Map.Entry entry : map.entrySet()) {
                    result.add(((InetSocketAddress)entry.getKey()).getHostName() + ":" + ((InetSocketAddress)entry.getKey()).getPort());
                    if (entry.getValue() == null) {
                        result.add();
                        continue;
                    }
                    result.add((String)entry.getValue());
                }
                return new ModelNode().set(result);
            }
            return null;
        }
    }
    ,
    REFRESH("refresh"){

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) {
            service.refresh();
            return null;
        }
    }
    ,
    RESET("reset"){

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) {
            service.reset();
            return null;
        }
    }
    ,
    ENABLE("enable"){

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) {
            boolean enabled = service.enable();
            return new ModelNode().get("result").set(enabled);
        }
    }
    ,
    DISABLE("disable"){

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) {
            boolean disabled = service.disable();
            return new ModelNode().get("result").set(disabled);
        }
    }
    ,
    STOP("stop"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setParameters(new AttributeDefinition[]{ProxyOperationExecutor.WAIT_TIME});
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) throws OperationFailedException {
            int waitTime = ProxyOperationExecutor.WAIT_TIME.resolveModelAttribute(expressionResolver, operation).asInt();
            boolean success = service.stop((long)waitTime, TimeUnit.SECONDS);
            return new ModelNode().get("session-draining-complete").set(success);
        }
    }
    ,
    ENABLE_CONTEXT("enable-context"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setParameters(new AttributeDefinition[]{ProxyOperationExecutor.VIRTUAL_HOST, ProxyOperationExecutor.CONTEXT});
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) throws OperationFailedException {
            String virtualHost = ProxyOperationExecutor.VIRTUAL_HOST.resolveModelAttribute(expressionResolver, operation).asString();
            String webContext = ProxyOperationExecutor.CONTEXT.resolveModelAttribute(expressionResolver, operation).asString();
            try {
                service.enableContext(virtualHost, webContext);
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.contextOrHostNotFound(virtualHost, webContext));
            }
            return null;
        }
    }
    ,
    DISABLE_CONTEXT("disable-context"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setParameters(new AttributeDefinition[]{ProxyOperationExecutor.VIRTUAL_HOST, ProxyOperationExecutor.CONTEXT});
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) throws OperationFailedException {
            String virtualHost = ProxyOperationExecutor.VIRTUAL_HOST.resolveModelAttribute(expressionResolver, operation).asString();
            String webContext = ProxyOperationExecutor.CONTEXT.resolveModelAttribute(expressionResolver, operation).asString();
            try {
                boolean disabled = service.disableContext(virtualHost, webContext);
                return new ModelNode().get("result").set(disabled);
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.contextOrHostNotFound(virtualHost, webContext));
            }
        }
    }
    ,
    STOP_CONTEXT("stop-context"){

        @Override
        public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
            return builder.setParameters(new AttributeDefinition[]{ProxyOperationExecutor.VIRTUAL_HOST, ProxyOperationExecutor.CONTEXT, ProxyOperationExecutor.WAIT_TIME});
        }

        public ModelNode execute(ExpressionResolver expressionResolver, ModelNode operation, ModClusterServiceMBean service) throws OperationFailedException {
            String virtualHost = ProxyOperationExecutor.VIRTUAL_HOST.resolveModelAttribute(expressionResolver, operation).asString();
            String webContext = ProxyOperationExecutor.CONTEXT.resolveModelAttribute(expressionResolver, operation).asString();
            int waitTime = ProxyOperationExecutor.WAIT_TIME.resolveModelAttribute(expressionResolver, operation).asInt();
            try {
                boolean success = service.stopContext(virtualHost, webContext, (long)waitTime, TimeUnit.SECONDS);
                return new ModelNode().get("session-draining-complete").set(success);
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.contextOrHostNotFound(virtualHost, webContext));
            }
        }
    };

    private final OperationDefinition definition;

    private ProxyOperation(String name) {
        this.definition = this.apply(new SimpleOperationDefinitionBuilder(name, (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER)).setRuntimeOnly().build();
    }

    public OperationDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public SimpleOperationDefinitionBuilder apply(SimpleOperationDefinitionBuilder builder) {
        return builder;
    }
}

