/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.realm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.sts.token.realm.Relationship;

public class RelationshipResolver {
    private Map<String, Relationship> relationshipMap = new HashMap<String, Relationship>();

    public RelationshipResolver(List<Relationship> relationships) {
        for (Relationship rel : relationships) {
            String key = this.generateKey(rel.getSourceRealm(), rel.getTargetRealm());
            this.relationshipMap.put(key, rel);
        }
    }

    public Relationship resolveRelationship(String sourceRealm, String targetRealm) {
        String key = this.generateKey(sourceRealm, targetRealm);
        return this.relationshipMap.get(key);
    }

    private String generateKey(String sourceRealm, String targetRealm) {
        return sourceRealm + ">" + targetRealm;
    }
}

