/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.remoting.ConnectorCommon;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.HttpConnectorResource;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.dmr.ModelNode;

public class RemotingTransformers
implements ExtensionTransformerRegistration {
    private static final ModelVersion VERSION_1_4 = ModelVersion.create((int)1, (int)4);
    private static final ModelVersion VERSION_3_0 = ModelVersion.create((int)3, (int)0);
    private static final ModelVersion VERSION_4_0 = ModelVersion.create((int)4, (int)0);
    private static final AttributeDefinition[] endpointAttrArray = RemotingEndpointResource.ATTRIBUTES.values().toArray(new AttributeDefinition[RemotingEndpointResource.ATTRIBUTES.values().size()]);

    public String getSubsystemName() {
        return "remoting";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        this.buildTransformers_4_0(chainedBuilder.createBuilder(registration.getCurrentSubsystemVersion(), VERSION_4_0));
        this.buildTransformers_3_0(chainedBuilder.createBuilder(VERSION_4_0, VERSION_3_0));
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{VERSION_4_0, VERSION_3_0}});
        ChainedTransformationDescriptionBuilder chained1xBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        this.buildTransformers_1_4(chained1xBuilder.createBuilder(registration.getCurrentSubsystemVersion(), VERSION_1_4));
        chained1xBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{VERSION_1_4}});
    }

    private void buildTransformers_1_4(ResourceTransformationDescriptionBuilder builder) {
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, RemotingEndpointResource.ATTRIBUTES.values())).addRejectCheck(RejectAttributeChecker.DEFINED, endpointAttrArray)).end();
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(ConnectorResource.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_AUTHENTICATION_FACTORY, ConnectorResource.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_AUTHENTICATION_FACTORY, ConnectorResource.SSL_CONTEXT});
        builder.rejectChildResource(HttpConnectorResource.PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(RemotingEndpointResource.ENDPOINT_PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, RemotingEndpointResource.ATTRIBUTES.values())).addRejectCheck(RejectAttributeChecker.DEFINED, endpointAttrArray)).end().addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD).end().setCustomResourceTransformer(ResourceTransformer.DISCARD);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(RemoteOutboundConnectionResourceDefinition.ADDRESS).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(Protocol.REMOTE.toString())}), new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.PROTOCOL})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.PROTOCOL})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_AUTHENTICATION_FACTORY})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.AUTHENTICATION_CONTEXT});
    }

    private void buildTransformers_3_0(ResourceTransformationDescriptionBuilder builder) {
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(ConnectorResource.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_AUTHENTICATION_FACTORY, ConnectorResource.SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_AUTHENTICATION_FACTORY, ConnectorResource.SSL_CONTEXT});
        builder.addChildResource(RemotingEndpointResource.ENDPOINT_PATH).getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (!attributeValue.isDefined()) {
                    attributeValue.set("remoting");
                }
            }
        }, new AttributeDefinition[]{RemotingSubsystemRootResource.SASL_PROTOCOL});
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(HttpConnectorResource.PATH).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_AUTHENTICATION_FACTORY})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_AUTHENTICATION_FACTORY});
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(RemoteOutboundConnectionResourceDefinition.ADDRESS).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ConnectorCommon.SASL_AUTHENTICATION_FACTORY})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.AUTHENTICATION_CONTEXT});
    }

    private void buildTransformers_4_0(ResourceTransformationDescriptionBuilder builder) {
        EndPointWriteTransformer endPointWriteTransformer = new EndPointWriteTransformer();
        ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, endpointAttrArray)).end().addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)new EndPointAddTransformer()).end().addOperationTransformationOverride("write-attribute").setCustomOperationTransformer((OperationTransformer)endPointWriteTransformer).end().addOperationTransformationOverride("undefine-attribute").setCustomOperationTransformer((OperationTransformer)endPointWriteTransformer).end();
    }

    private static class EndPointWriteTransformer
    implements OperationTransformer {
        private EndPointWriteTransformer() {
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            ModelNode transformed;
            if (RemotingEndpointResource.ATTRIBUTES.containsKey(operation.get("name").asString())) {
                transformed = operation.clone();
                PathAddress endpointAddress = address.append(new PathElement[]{RemotingEndpointResource.ENDPOINT_PATH});
                transformed.get("address").set(endpointAddress.toModelNode());
            } else {
                transformed = operation;
            }
            return new OperationTransformer.TransformedOperation(transformed, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }

    private static class EndPointAddTransformer
    implements OperationTransformer {
        private EndPointAddTransformer() {
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            ModelNode transformed;
            ModelNode trimmedAdd = null;
            ModelNode endPointAdd = null;
            for (AttributeDefinition ad : RemotingEndpointResource.ATTRIBUTES.values()) {
                String adName = ad.getName();
                if (!operation.hasDefined(adName)) continue;
                if (endPointAdd == null) {
                    trimmedAdd = operation.clone();
                    PathAddress endpointAddress = address.append(new PathElement[]{RemotingEndpointResource.ENDPOINT_PATH});
                    endPointAdd = Util.createEmptyOperation((String)operation.get("operation").asString(), (PathAddress)endpointAddress);
                }
                endPointAdd.get(adName).set(operation.get(adName));
                trimmedAdd.remove(adName);
            }
            if (endPointAdd != null) {
                transformed = Util.createEmptyOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
                ModelNode steps = transformed.get("steps");
                steps.add(trimmedAdd);
                steps.add(endPointAdd);
            } else {
                transformed = operation;
            }
            return new OperationTransformer.TransformedOperation(transformed, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

