/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.batch.jberet.Attribute;
import org.wildfly.extension.batch.jberet.AttributeParsers;
import org.wildfly.extension.batch.jberet.BatchSubsystemDefinition;
import org.wildfly.extension.batch.jberet.Element;
import org.wildfly.extension.batch.jberet.Namespace;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryDefinition;

public class BatchSubsystemParser_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    private final Map<Element, SimpleAttributeDefinition> attributeElements;

    public BatchSubsystemParser_1_0() {
        this(Collections.emptyMap());
    }

    BatchSubsystemParser_1_0(Map<Element, SimpleAttributeDefinition> additionalElements) {
        this.attributeElements = new HashMap<Element, SimpleAttributeDefinition>(additionalElements);
        this.attributeElements.put(Element.DEFAULT_JOB_REPOSITORY, BatchSubsystemDefinition.DEFAULT_JOB_REPOSITORY);
        this.attributeElements.put(Element.DEFAULT_THREAD_POOL, BatchSubsystemDefinition.DEFAULT_THREAD_POOL);
        this.attributeElements.put(Element.RESTART_JOBS_ON_RESUME, BatchSubsystemDefinition.RESTART_JOBS_ON_RESUME);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> ops) throws XMLStreamException {
        ThreadsParser threadsParser = ThreadsParser.getInstance();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{BatchSubsystemDefinition.SUBSYSTEM_PATH});
        ModelNode subsystemAddOp = Util.createAddOperation((PathAddress)subsystemAddress);
        ops.add(subsystemAddOp);
        EnumSet<Element> requiredElements = EnumSet.of(Element.JOB_REPOSITORY, Element.THREAD_POOL);
        this.attributeElements.forEach((element, attribute) -> {
            if (!attribute.isAllowNull() && attribute.getDefaultValue() == null) {
                requiredElements.add((Element)((Object)element));
            }
        });
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element2 = Element.forName(localName);
            SimpleAttributeDefinition attribute2 = this.attributeElements.get((Object)element2);
            if (attribute2 != null) {
                AttributeParser parser = attribute2.getParser();
                if (parser.isParseAsElement()) {
                    parser.parseElement((AttributeDefinition)attribute2, reader, subsystemAddOp);
                } else {
                    parser.parseAndSetParameter((AttributeDefinition)attribute2, AttributeParsers.readNameAttribute(reader), subsystemAddOp, (XMLStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                }
                requiredElements.remove((Object)element2);
                continue;
            }
            if (element2 == Element.JOB_REPOSITORY) {
                String name = AttributeParsers.readNameAttribute(reader);
                this.parseJobRepository(reader, subsystemAddress, name, ops);
                requiredElements.remove((Object)Element.JOB_REPOSITORY);
                continue;
            }
            if (element2 == Element.THREAD_POOL) {
                threadsParser.parseUnboundedQueueThreadPool(reader, namespace.getUriString(), org.jboss.as.threads.Namespace.THREADS_1_1, subsystemAddress.toModelNode(), ops, "thread-pool", null);
                requiredElements.remove((Object)Element.THREAD_POOL);
                continue;
            }
            if (element2 == Element.THREAD_FACTORY) {
                threadsParser.parseThreadFactory(reader, namespace.getUriString(), org.jboss.as.threads.Namespace.THREADS_1_1, subsystemAddress.toModelNode(), ops, "thread-factory", null);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElements.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElements);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJobRepository(XMLExtendedStreamReader reader, PathAddress subsystemAddress, String name, List<ModelNode> ops) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.IN_MEMORY) {
                ops.add(Util.createAddOperation((PathAddress)subsystemAddress.append("in-memory-job-repository", name)));
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            if (element == Element.JDBC) {
                Map<Attribute, String> attributes = AttributeParsers.readRequiredAttributes(reader, EnumSet.of(Attribute.DATA_SOURCE));
                ModelNode op = Util.createAddOperation((PathAddress)subsystemAddress.append("jdbc-job-repository", name));
                JdbcJobRepositoryDefinition.DATA_SOURCE.parseAndSetParameter(attributes.get((Object)Attribute.DATA_SOURCE), op, (XMLStreamReader)reader);
                ops.add(op);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

