/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.jmx.export.runtime;

import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.modelmbean.ModelMBeanInfo;
import org.apache.cxf.management.annotation.ManagedAttribute;
import org.apache.cxf.management.annotation.ManagedNotification;
import org.apache.cxf.management.annotation.ManagedNotifications;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedOperationParameter;
import org.apache.cxf.management.annotation.ManagedOperationParameters;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.management.jmx.export.runtime.ModelMBeanInfoSupporter;

public class ModelMBeanAssembler {
    private ModelMBeanInfoSupporter supporter = new ModelMBeanInfoSupporter();

    public ManagedResource getManagedResource(Class<?> clazz) {
        return clazz.getAnnotation(ManagedResource.class);
    }

    public ManagedAttribute getManagedAttribute(Method method) {
        return method.getAnnotation(ManagedAttribute.class);
    }

    public ManagedOperation getManagedOperation(Method method) {
        return method.getAnnotation(ManagedOperation.class);
    }

    public ManagedOperationParameter[] getManagedOperationParameters(Method method) {
        ManagedOperationParameters params = method.getAnnotation(ManagedOperationParameters.class);
        ManagedOperationParameter[] result = null;
        result = params == null ? new ManagedOperationParameter[]{} : params.value();
        return result;
    }

    public ManagedNotification[] getManagedNotifications(Class<?> clazz) {
        ManagedNotifications notificationsAnn = clazz.getAnnotation(ManagedNotifications.class);
        ManagedNotification[] result = null;
        if (null == notificationsAnn) {
            return new ManagedNotification[0];
        }
        result = notificationsAnn.value();
        return result;
    }

    public String getAttributeName(String methodName) {
        if (methodName.indexOf("set") == 0) {
            return methodName.substring(3);
        }
        if (methodName.indexOf("get") == 0) {
            return methodName.substring(3);
        }
        if (methodName.indexOf("is") == 0) {
            return methodName.substring(2);
        }
        return null;
    }

    public static boolean checkMethod(Method[] methods, String methodName) {
        boolean result = false;
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName().compareTo(methodName) != 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getAttributeType(Method[] methods, String attributeName) {
        int i;
        String result = null;
        String searchMethod = "get" + attributeName;
        for (i = 0; i < methods.length; ++i) {
            if (methods[i].getName().compareTo(searchMethod) != 0) continue;
            result = methods[i].getReturnType().getName();
            break;
        }
        if (null == result) {
            searchMethod = "is" + attributeName;
            for (i = 0; i < methods.length; ++i) {
                if (methods[i].getName().compareTo(searchMethod) != 0) continue;
                result = methods[i].getReturnType().getName();
                break;
            }
        }
        return result;
    }

    public ManagedAttributeInfo getAttributInfo(Method[] methods, String attributName, String attributType, ManagedAttribute managedAttribute) {
        ManagedAttributeInfo mai = new ManagedAttributeInfo();
        mai.fname = attributName;
        mai.ftype = attributType;
        mai.description = managedAttribute.description();
        mai.is = ModelMBeanAssembler.checkMethod(methods, "is" + attributName);
        mai.write = ModelMBeanAssembler.checkMethod(methods, "set" + attributName);
        mai.read = mai.is ? true : ModelMBeanAssembler.checkMethod(methods, "get" + attributName);
        return mai;
    }

    Method findMethodByName(Method[] methods, String methodName) {
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName().compareTo(methodName) != 0) continue;
            return methods[i];
        }
        return null;
    }

    void addAttributeOperation(Method method) {
        Descriptor operationDescriptor = this.supporter.buildAttributeOperationDescriptor(method.getName());
        Class<?>[] types = method.getParameterTypes();
        String[] paramTypes = new String[types.length];
        String[] paramNames = new String[types.length];
        String[] paramDescs = new String[types.length];
        for (int j = 0; j < types.length; ++j) {
            paramTypes[j] = types[j].getName();
            paramDescs[j] = "";
            paramNames[j] = types[j].getName();
        }
        this.supporter.addModelMBeanMethod(method.getName(), paramTypes, paramNames, paramDescs, "", method.getReturnType().getName(), operationDescriptor);
    }

    public ModelMBeanInfo getModelMbeanInfo(Class<?> clazz) {
        this.supporter.clear();
        ManagedResource mr = this.getManagedResource(clazz);
        if (mr == null) {
            return null;
        }
        Descriptor mbeanDescriptor = this.supporter.buildMBeanDescriptor(mr);
        ManagedNotification[] mns = this.getManagedNotifications(clazz);
        for (int k = 0; k < mns.length; ++k) {
            this.supporter.addModelMBeanNotification(mns[k].notificationTypes(), mns[k].name(), mns[k].description(), null);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            ManagedAttribute ma = this.getManagedAttribute(methods[i]);
            if (ma != null) {
                Method method;
                String attributeName = this.getAttributeName(methods[i].getName());
                if (this.supporter.checkAttribute(attributeName)) continue;
                String attributeType = ModelMBeanAssembler.getAttributeType(methods, attributeName);
                ManagedAttributeInfo mai = this.getAttributInfo(methods, attributeName, attributeType, ma);
                Descriptor attributeDescriptor = this.supporter.buildAttributeDescriptor(ma, attributeName, mai.is, mai.read, mai.write);
                this.supporter.addModelMBeanAttribute(mai.fname, mai.ftype, mai.read, mai.write, mai.is, mai.description, attributeDescriptor);
                if (mai.read) {
                    method = mai.is ? this.findMethodByName(methods, "is" + attributeName) : this.findMethodByName(methods, "get" + attributeName);
                    this.addAttributeOperation(method);
                }
                if (!mai.write) continue;
                method = this.findMethodByName(methods, "set" + attributeName);
                this.addAttributeOperation(method);
                continue;
            }
            ManagedOperation mo = this.getManagedOperation(methods[i]);
            if (mo == null) continue;
            Class<?>[] types = methods[i].getParameterTypes();
            ManagedOperationParameter[] mop = this.getManagedOperationParameters(methods[i]);
            String[] paramTypes = new String[types.length];
            String[] paramNames = new String[types.length];
            String[] paramDescs = new String[types.length];
            for (int j = 0; j < types.length; ++j) {
                paramTypes[j] = types[j].getName();
                if (j < mop.length) {
                    paramDescs[j] = mop[j].description();
                    paramNames[j] = mop[j].name();
                    continue;
                }
                paramDescs[j] = "";
                paramNames[j] = types[j].getName();
            }
            Descriptor operationDescriptor = this.supporter.buildOperationDescriptor(mo, methods[i].getName());
            this.supporter.addModelMBeanMethod(methods[i].getName(), paramTypes, paramNames, paramDescs, mo.description(), methods[i].getReturnType().getName(), operationDescriptor);
        }
        return this.supporter.buildModelMBeanInfo(mbeanDescriptor);
    }

    static class ManagedAttributeInfo {
        String fname;
        String ftype;
        String description;
        boolean read;
        boolean write;
        boolean is;

        ManagedAttributeInfo() {
        }
    }
}

