/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.subject;

import java.security.Principal;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.CacheableManager;
import org.picketlink.identity.federation.bindings.tomcat.SubjectSecurityInteraction;

public class PicketLinkJBossSubjectInteraction
implements SubjectSecurityInteraction {
    private String securityDomain;

    @Override
    public boolean cleanup(Principal principal) {
        if (this.securityDomain != null && !"".equals(this.securityDomain)) {
            try {
                String lookupDomain = this.securityDomain;
                if (!lookupDomain.startsWith("java:jboss/jaas/")) {
                    lookupDomain = "java:jboss/jaas//" + lookupDomain;
                }
                InitialContext context = new InitialContext();
                CacheableManager manager = (CacheableManager)context.lookup(lookupDomain);
                manager.flushCache((Object)principal);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public Subject get() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (PolicyContextException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }
}

