/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.SimpleName;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;

public abstract class AbstractFederatingContext
extends AbstractContext {
    protected AbstractFederatingContext(FastHashtable<String, Object> environment) {
        super(environment);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        return this.lookup(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name instanceof CompositeName) {
            if (name.isEmpty()) {
                return this.lookupNative(new SimpleName());
            }
            String first = name.get(0);
            Object next = this.lookup(this.getNativeNameParser().parse(first));
            if (name.size() == 1) {
                return next;
            }
            if (next instanceof Context) {
                Context context = (Context)next;
                try {
                    Object object = context.lookup(name.getSuffix(1));
                    return object;
                }
                finally {
                    NamingUtils.safeClose(context);
                }
            }
            throw Messages.log.notContextInCompositeName(first);
        }
        return this.lookupNative(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        return this.lookupLink(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name instanceof CompositeName) {
            String first = name.get(0);
            Name firstName = this.getNativeNameParser().parse(first);
            if (name.size() == 1) {
                return this.lookupLink(firstName);
            }
            Object next = this.lookup(firstName);
            if (next instanceof Context) {
                Context context = (Context)next;
                try {
                    Object object = context.lookupLink(name.getSuffix(1));
                    return object;
                }
                finally {
                    NamingUtils.safeClose(context);
                }
            }
            throw Messages.log.notContextInCompositeName(first);
        }
        return this.lookupLinkNative(name);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam("name", name);
        this.bind(new CompositeName(name), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void bind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            String first = name.get(0);
            Name firstName = this.getNativeNameParser().parse(first);
            if (name.size() == 1) {
                this.bindNative(firstName, obj);
                return;
            }
            Object next = this.lookup(firstName);
            if (!(next instanceof Context)) throw Messages.log.notContextInCompositeName(first);
            Context context = (Context)next;
            try {
                context.bind(name.getSuffix(1), obj);
                return;
            }
            finally {
                NamingUtils.safeClose(context);
            }
        } else {
            this.bindNative(name, obj);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam("name", name);
        this.rebind(new CompositeName(name), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            String first = name.get(0);
            Name firstName = this.getNativeNameParser().parse(first);
            if (name.size() == 1) {
                this.rebindNative(firstName, obj);
                return;
            }
            Object next = this.lookup(firstName);
            if (!(next instanceof Context)) throw Messages.log.notContextInCompositeName(first);
            Context context = (Context)next;
            try {
                context.rebind(name.getSuffix(1), obj);
                return;
            }
            finally {
                NamingUtils.safeClose(context);
            }
        } else {
            this.rebindNative(name, obj);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        this.unbind(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unbind(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            String first = name.get(0);
            Name firstName = this.getNativeNameParser().parse(first);
            if (name.size() == 1) {
                this.unbindNative(firstName);
                return;
            }
            Object next = this.lookup(firstName);
            if (!(next instanceof Context)) throw Messages.log.notContextInCompositeName(first);
            Context context = (Context)next;
            try {
                context.unbind(name.getSuffix(1));
                return;
            }
            finally {
                NamingUtils.safeClose(context);
            }
        } else {
            this.unbindNative(name);
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Assert.checkNotNullParam("oldName", oldName);
        Assert.checkNotNullParam("newName", newName);
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Name target;
        Assert.checkNotNullParam("oldName", oldName);
        Assert.checkNotNullParam("newName", newName);
        if (oldName.isEmpty() || newName.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (oldName instanceof CompositeName) {
            String oldFirst = oldName.get(0);
            Name oldFirstName = this.getNativeNameParser().parse(oldFirst);
            Name newFirstName = newName instanceof CompositeName ? this.getNativeNameParser().parse(newName.get(0)) : newName;
            if (oldName.size() == 1 && newName.size() == 1) {
                this.renameNative(oldFirstName, newFirstName);
                return;
            }
            if (!oldFirstName.equals(newFirstName)) {
                throw Messages.log.renameAcrossProviders(oldName, newName);
            }
            Object next = this.lookupNative(oldFirstName);
            if (!(next instanceof Context)) throw Messages.log.notContextInCompositeName(oldFirst);
            Context context = (Context)next;
            try {
                context.rename(oldName.getSuffix(1), newName.getSuffix(1));
                return;
            }
            finally {
                NamingUtils.safeClose(context);
            }
        }
        if (newName instanceof CompositeName) {
            if (newName.size() != 1) throw Messages.log.renameAcrossProviders(oldName, newName);
            target = this.getNativeNameParser().parse(newName.get(0));
        } else {
            target = newName;
        }
        this.renameNative(oldName, target);
    }

    @Override
    public CloseableNamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        return this.list(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableNamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name instanceof CompositeName) {
            if (name.isEmpty()) {
                return this.listNative(new SimpleName());
            }
            String first = name.get(0);
            Name firstName = this.getNativeNameParser().parse(first);
            if (name.size() == 1) {
                return this.listNative(firstName);
            }
            Object next = this.lookup(firstName);
            if (next instanceof Context) {
                Context context = (Context)next;
                try {
                    CloseableNamingEnumeration<NameClassPair> closeableNamingEnumeration = CloseableNamingEnumeration.fromEnumeration(context.list(name.getSuffix(1)));
                    return closeableNamingEnumeration;
                }
                finally {
                    NamingUtils.safeClose(context);
                }
            }
            throw Messages.log.notContextInCompositeName(first);
        }
        return this.listNative(name);
    }

    @Override
    public CloseableNamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        return this.listBindings(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableNamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name instanceof CompositeName) {
            if (name.isEmpty()) {
                return this.listBindingsNative(new SimpleName());
            }
            String first = name.get(0);
            Name firstName = this.getNativeNameParser().parse(first);
            if (name.size() == 1) {
                return this.listBindingsNative(firstName);
            }
            Object next = this.lookup(firstName);
            if (next instanceof Context) {
                Context context = (Context)next;
                try {
                    CloseableNamingEnumeration<Binding> closeableNamingEnumeration = CloseableNamingEnumeration.fromEnumeration(context.listBindings(name.getSuffix(1)));
                    return closeableNamingEnumeration;
                }
                finally {
                    NamingUtils.safeClose(context);
                }
            }
            throw Messages.log.notContextInCompositeName(first);
        }
        return this.listBindingsNative(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        this.destroySubcontext(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            String first = name.get(0);
            Name firstName = this.getNativeNameParser().parse(first);
            if (name.size() == 1) {
                this.destroySubcontext(firstName);
                return;
            }
            Object next = this.lookup(firstName);
            if (next instanceof Context) {
                Context context = (Context)next;
                try {
                    context.destroySubcontext(name.getSuffix(1));
                    return;
                }
                finally {
                    NamingUtils.safeClose(context);
                }
            }
            throw Messages.log.notContextInCompositeName(first);
        }
        this.destroySubcontextNative(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        return this.createSubcontext(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw Messages.log.invalidEmptyName();
        }
        if (name instanceof CompositeName) {
            String first = name.get(0);
            Name firstName = this.getNativeNameParser().parse(first);
            if (name.size() == 1) {
                return this.createSubcontext(firstName);
            }
            Object next = this.lookup(firstName);
            if (next instanceof Context) {
                Context context = (Context)next;
                try {
                    Context context2 = context.createSubcontext(name.getSuffix(1));
                    return context2;
                }
                finally {
                    NamingUtils.safeClose(context);
                }
            }
            throw Messages.log.notContextInCompositeName(first);
        }
        return this.createSubcontextNative(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Assert.checkNotNullParam("name", name);
        Assert.checkNotNullParam("prefix", prefix);
        CompositeName first = new CompositeName(prefix);
        CompositeName second = new CompositeName(name);
        first.addAll(second);
        return first.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        CompositeName compositeName;
        Assert.checkNotNullParam("name", name);
        Assert.checkNotNullParam("prefix", prefix);
        if (prefix instanceof CompositeName) {
            compositeName = (CompositeName)prefix.clone();
        } else {
            compositeName = new CompositeName();
            compositeName.add(prefix.toString());
        }
        if (name instanceof CompositeName) {
            compositeName.addAll(name);
        } else {
            compositeName.add(name.toString());
        }
        return compositeName;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name.isEmpty()) {
            return this.getNativeNameParser();
        }
        CompositeName compositeName = new CompositeName(name);
        return this.getNameParser(compositeName);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        Assert.checkNotNullParam("name", name);
        if (name instanceof CompositeName) {
            return this.getNameParser((CompositeName)name);
        }
        return this.getNativeNameParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameParser getNameParser(CompositeName compositeName) throws NamingException {
        if (compositeName.isEmpty()) {
            return this.getNativeNameParser();
        }
        String first = compositeName.get(0);
        Name nativeName = this.getNativeNameParser().parse(first);
        Object obj = this.lookup(nativeName);
        if (obj instanceof Context) {
            Context context = (Context)obj;
            try {
                NameParser nameParser = context.getNameParser(compositeName.getSuffix(1));
                return nameParser;
            }
            finally {
                NamingUtils.safeClose(context);
            }
        }
        throw Messages.log.notContextInCompositeName(first);
    }
}

