/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.spec.PasswordSpec;

public class IteratedHashPasswordSpec
implements PasswordSpec {
    private final byte[] hash;
    private final int iterationCount;

    public IteratedHashPasswordSpec(byte[] hash, int iterationCount) {
        Assert.checkNotNullParam("hash", hash);
        this.hash = hash;
        this.iterationCount = iterationCount;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IteratedHashPasswordSpec)) {
            return false;
        }
        IteratedHashPasswordSpec o = (IteratedHashPasswordSpec)other;
        return Arrays.equals(this.hash, o.hash) && this.iterationCount == o.iterationCount;
    }

    public int hashCode() {
        return HashMath.multiHashOrdered(Arrays.hashCode(this.hash), this.iterationCount);
    }
}

