/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.util.StringEnumeration;

public final class StringMapping<T> {
    private final StringEnumeration stringEnumeration;
    private final T[] items;

    public StringMapping(StringEnumeration stringEnumeration, Function<String, T> mapping) {
        Assert.checkNotNullParam("stringEnumeration", stringEnumeration);
        Assert.checkNotNullParam("mapping", mapping);
        this.stringEnumeration = stringEnumeration;
        Object[] items = new Object[stringEnumeration.size()];
        for (int i = 0; i < stringEnumeration.size(); ++i) {
            items[i] = mapping.apply(stringEnumeration.nameOf(i));
        }
        this.items = items;
    }

    public T getItemById(int index) throws IllegalArgumentException {
        Assert.checkMinimumParameter("index", 0, index);
        Assert.checkMaximumParameter("index", this.stringEnumeration.size() - 1, index);
        return this.items[index];
    }

    public T getItemByString(String str) throws IllegalArgumentException {
        Assert.checkNotNullParam("str", str);
        return this.items[this.stringEnumeration.indexOf(str)];
    }

    public StringEnumeration getStringEnumeration() {
        return this.stringEnumeration;
    }
}

