/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jboss.dmr.ModelNode;

public class ListEditor
extends JPanel
implements ListSelectionListener {
    private DefaultListModel listModel = new DefaultListModel();
    private JList list = new JList(this.listModel);
    private Dialog parent;
    private JButton addButton = new JButton("Add...");
    private JButton editButton = new JButton("Edit...");
    private JButton removeButton = new JButton("Remove");
    private JButton moveUpButton = new JButton("\u25b2");
    private JButton moveDownButton = new JButton("\u25bc");

    public ListEditor(Dialog parent) {
        this.parent = parent;
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.setPrototypeCellValue("012345678901234567890123456789");
        this.list.addListSelectionListener(this);
        JPanel buttonColumn = this.makeButtonColumn();
        JScrollPane scroller = new JScrollPane(this.list);
        JPanel moveUpDownColumn = this.makeMoveUpDownColumn();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.gridx = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        this.add((Component)buttonColumn, gbConst);
        this.add(Box.createHorizontalStrut(5));
        gbConst.fill = 1;
        gbConst.gridx = -1;
        gbConst.weightx = 10.0;
        this.add((Component)scroller, gbConst);
        this.add(Box.createHorizontalStrut(5));
        gbConst.fill = 0;
        gbConst.weightx = 1.0;
        this.add((Component)moveUpDownColumn, gbConst);
    }

    private JPanel makeButtonColumn() {
        JPanel buttonColumn = new JPanel(new GridLayout(3, 1, 5, 5));
        this.addButton.setToolTipText("Add an item to the list.");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ItemEditor editor = new ItemEditor();
                editor.setVisible(true);
                ListEditor.this.list.setSelectedIndex(ListEditor.this.list.getLastVisibleIndex());
            }
        });
        this.editButton.setToolTipText("Edit selected item.");
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ItemEditor editor = new ItemEditor(ListEditor.this.list.getSelectedValue().toString());
                editor.setVisible(true);
            }
        });
        this.removeButton.setToolTipText("Remove selected item.");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ListEditor.this.listModel.remove(ListEditor.this.list.getSelectedIndex());
            }
        });
        buttonColumn.add(this.addButton);
        buttonColumn.add(this.editButton);
        buttonColumn.add(this.removeButton);
        return buttonColumn;
    }

    private JPanel makeMoveUpDownColumn() {
        JPanel buttonColumn = new JPanel(new GridLayout(2, 1, 5, 5));
        this.moveUpButton.setToolTipText("Move selected item up.");
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedIndex = ListEditor.this.list.getSelectedIndex();
                Object toBeMoved = ListEditor.this.listModel.remove(selectedIndex);
                ListEditor.this.listModel.add(selectedIndex - 1, toBeMoved);
                ListEditor.this.list.setSelectedIndex(selectedIndex - 1);
            }
        });
        this.moveDownButton.setToolTipText("Move selected item down.");
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedIndex = ListEditor.this.list.getSelectedIndex();
                Object toBeMoved = ListEditor.this.listModel.remove(selectedIndex);
                ListEditor.this.listModel.add(selectedIndex + 1, toBeMoved);
                ListEditor.this.list.setSelectedIndex(selectedIndex + 1);
            }
        });
        buttonColumn.add(this.moveUpButton);
        buttonColumn.add(this.moveDownButton);
        return buttonColumn;
    }

    public ModelNode getValue() {
        ModelNode value = new ModelNode();
        Enumeration elements = this.listModel.elements();
        while (elements.hasMoreElements()) {
            value.add(elements.nextElement().toString());
        }
        return value;
    }

    public void setValue(ModelNode value) {
        if (!value.isDefined()) {
            return;
        }
        for (ModelNode item : value.asList()) {
            this.listModel.addElement(item.asString());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex == -1) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            return;
        }
        this.editButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.moveUpButton.setEnabled(selectedIndex != 0);
        this.moveDownButton.setEnabled(selectedIndex != this.list.getLastVisibleIndex());
    }

    private class ItemEditor
    extends JDialog {
        private boolean isAddMode;
        private JTextField itemField;

        public ItemEditor() {
            this("Add Item", "");
        }

        public ItemEditor(String item) {
            this("Edit Item", item);
            this.isAddMode = false;
        }

        private ItemEditor(String label, String item) {
            super(ListEditor.this.parent, label, true);
            this.isAddMode = true;
            this.itemField = new JTextField(30);
            this.setLocationRelativeTo(ListEditor.this.parent);
            this.setDefaultCloseOperation(2);
            this.itemField.setText(item);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout(10, 10));
            contentPane.add((Component)this.itemField, "Center");
            contentPane.add((Component)this.makeButtonPanel(), "South");
            this.pack();
            this.setResizable(false);
        }

        private JPanel makeButtonPanel() {
            JPanel buttonPanel = new JPanel();
            JButton ok = new JButton("OK");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String editedItem = ItemEditor.this.itemField.getText();
                    if (ItemEditor.this.isAddMode) {
                        ListEditor.this.listModel.addElement(editedItem);
                    } else {
                        ListEditor.this.listModel.set(ListEditor.this.list.getSelectedIndex(), editedItem);
                    }
                    ItemEditor.this.dispose();
                }
            });
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ItemEditor.this.dispose();
                }
            });
            buttonPanel.add(ok);
            buttonPanel.add(cancel);
            return buttonPanel;
        }
    }
}

