/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment.security;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.accesscontrol.PerNodeOperationAccess;

public class Permissions {
    private final AccessRequirement listPermission;
    private final AccessRequirement fullReplacePermission;
    private final AccessRequirement mainAddPermission;
    private final AccessRequirement deployPermission;
    private final AccessRequirement addOrReplacePermission;
    private final PerNodeOperationAccess serverGroupAddPermission;
    private final PerNodeOperationAccess sgChildrenResourcesPermission;
    private final AccessRequirement mainRemovePermission;
    private final AccessRequirement undeployPermission;
    private final AccessRequirement removeOrUndeployPermission;

    public Permissions(CommandContext ctx) {
        this.listPermission = AccessRequirementBuilder.Factory.create(ctx).all().operation("read-children-names").operation("deployment=?", "read-resource").build();
        this.fullReplacePermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("full-replace-deployment").build();
        this.mainAddPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "add").build();
        this.serverGroupAddPermission = new PerNodeOperationAccess(ctx, "server-group", "deployment=?", "add");
        this.deployPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "deploy").all().requirement(this.serverGroupAddPermission).serverGroupOperation("deployment=?", "deploy").parent().build();
        this.sgChildrenResourcesPermission = new PerNodeOperationAccess(ctx, "server-group", null, "read-children-resources");
        this.addOrReplacePermission = AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.mainAddPermission).requirement(this.fullReplacePermission).build();
        this.mainRemovePermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "remove").build();
        this.undeployPermission = AccessRequirementBuilder.Factory.create(ctx).any().operation("deployment=?", "undeploy").all().serverGroupOperation("deployment=?", "remove").serverGroupOperation("deployment=?", "undeploy").parent().build();
        this.removeOrUndeployPermission = AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.mainRemovePermission).requirement(this.undeployPermission).build();
    }

    public AccessRequirement getListPermission() {
        return this.listPermission;
    }

    public AccessRequirement getFullReplacePermission() {
        return this.fullReplacePermission;
    }

    public AccessRequirement getMainAddPermission() {
        return this.mainAddPermission;
    }

    public AccessRequirement getDeployPermission() {
        return this.deployPermission;
    }

    public AccessRequirement getAddOrReplacePermission() {
        return this.addOrReplacePermission;
    }

    public PerNodeOperationAccess getServerGroupAddPermission() {
        return this.serverGroupAddPermission;
    }

    public PerNodeOperationAccess getSgChildrenResourcesPermission() {
        return this.sgChildrenResourcesPermission;
    }

    public AccessRequirement getMainRemovePermission() {
        return this.mainRemovePermission;
    }

    public AccessRequirement getUndeployPermission() {
        return this.undeployPermission;
    }

    public AccessRequirement getRemoveOrUndeployPermission() {
        return this.removeOrUndeployPermission;
    }
}

