/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import org.jboss.as.controller.ExpressionResolverImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.VaultReader;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class RuntimeExpressionResolver
extends ExpressionResolverImpl {
    private static final Logger log = Logger.getLogger(RuntimeExpressionResolver.class);
    private final VaultReader vaultReader;

    public RuntimeExpressionResolver(VaultReader vaultReader) {
        this.vaultReader = vaultReader;
    }

    protected void resolvePluggableExpression(ModelNode node) throws OperationFailedException {
        String expression = node.asString();
        if (expression.length() > 3) {
            String vaultedData = expression.substring(2, expression.length() - 1);
            if (this.vaultReader == null) {
                if (VaultReader.STANDARD_VAULT_PATTERN.matcher(vaultedData).matches()) {
                    log.tracef("Cannot resolve %s -- it is in the default vault format but no vault reader is available", (Object)vaultedData);
                    throw ControllerLogger.ROOT_LOGGER.cannotResolveExpression(expression);
                }
                log.tracef("Not resolving %s -- no vault reader available and not in default vault format", (Object)vaultedData);
            } else if (this.vaultReader.isVaultFormat(vaultedData)) {
                try {
                    String retrieved = this.vaultReader.retrieveFromVault(vaultedData);
                    log.tracef("Retrieved %s from vault for %s", (Object)retrieved, (Object)vaultedData);
                    node.set(retrieved);
                }
                catch (VaultReader.NoSuchItemException nsie) {
                    throw ControllerLogger.ROOT_LOGGER.cannotResolveExpression(expression);
                }
            } else {
                log.tracef("Not resolving %s -- not in vault format", (Object)vaultedData);
            }
        }
    }
}

