/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.vfs.VirtualFile;

public class ModuleIdentifierProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        DeploymentUnit parent = deploymentUnit.getParent();
        DeploymentUnit topLevelDeployment = parent == null ? deploymentUnit : parent;
        VirtualFile toplevelRoot = topLevelDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT).getRoot();
        ModuleIdentifier moduleIdentifier = ModuleIdentifierProcessor.createModuleIdentifier(deploymentUnit.getName(), deploymentRoot, topLevelDeployment, toplevelRoot, deploymentUnit.getParent() == null);
        deploymentUnit.putAttachment(Attachments.MODULE_IDENTIFIER, moduleIdentifier);
    }

    public static ModuleIdentifier createModuleIdentifier(String deploymentUnitName, ResourceRoot deploymentRoot, DeploymentUnit topLevelDeployment, VirtualFile toplevelRoot, boolean topLevel) {
        ModuleIdentifier moduleIdentifier;
        if (topLevel) {
            moduleIdentifier = ModuleIdentifier.create((String)("deployment." + deploymentUnitName));
        } else {
            String relativePath = deploymentRoot.getRoot().getPathNameRelativeTo(toplevelRoot);
            moduleIdentifier = ModuleIdentifier.create((String)("deployment." + topLevelDeployment.getName() + '.' + relativePath.replace('/', '.')));
        }
        return moduleIdentifier;
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

