/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.man;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.aesh.command.Command;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.man.FileParser;
import org.aesh.command.man.TerminalPage;
import org.aesh.command.shell.Shell;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

public abstract class AeshFileDisplayer
implements Command {
    private int rows;
    private int columns;
    private int topVisibleRow;
    private int topVisibleRowCache;
    private TerminalPage page;
    private StringBuilder number;
    private TerminalPage.Search search = TerminalPage.Search.NO_SEARCH;
    private StringBuilder searchBuilder;
    private List<Integer> searchLines;
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshFileDisplayer.class.getName());
    private CommandInvocation commandInvocation;
    private boolean stop = false;

    protected void setCommandInvocation(CommandInvocation commandInvocation) {
        this.commandInvocation = commandInvocation;
    }

    protected CommandInvocation getCommandInvocation() {
        return this.commandInvocation;
    }

    protected Shell getShell() {
        return this.commandInvocation.getShell();
    }

    protected void afterAttach() throws IOException, InterruptedException {
        this.number = new StringBuilder();
        this.searchBuilder = new StringBuilder();
        this.rows = this.getShell().size().getHeight();
        this.columns = this.getShell().size().getWidth();
        this.page = new TerminalPage(this.getFileParser(), this.columns);
        this.topVisibleRow = 0;
        this.topVisibleRowCache = -1;
        this.stop = false;
        if (this.commandInvocation.getConfiguration().hasOutputRedirection()) {
            int count = 0;
            for (String line : this.page.getLines()) {
                this.commandInvocation.print(line);
                if (++count >= this.page.size()) continue;
                this.commandInvocation.print(Config.getLineSeparator());
            }
            this.page.clear();
        } else if (!this.page.hasData()) {
            this.getShell().write("error: input is null...");
            this.afterDetach();
        } else {
            this.getShell().write(ANSI.ALTERNATE_BUFFER);
            if (this.page.getFileName() != null) {
                this.display();
            } else {
                this.display();
            }
            this.processInput();
        }
    }

    protected void afterDetach() {
        if (!this.commandInvocation.getConfiguration().hasOutputRedirection()) {
            this.getShell().write(ANSI.MAIN_BUFFER);
        }
        this.page.clear();
        this.topVisibleRow = 0;
    }

    public void processInput() throws IOException, InterruptedException {
        try {
            while (!this.stop) {
                KeyAction event = this.getCommandInvocation().input();
                if (!(event instanceof Key)) continue;
                this.processOperation((Key)event);
            }
        }
        catch (InterruptedException e) {
            this.afterDetach();
            this.stop = true;
            throw e;
        }
    }

    public void processOperation(Key operation) throws IOException {
        if (operation == Key.q) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getFirstValue());
                this.displayBottom();
            } else {
                this.clearNumber();
                this.afterDetach();
                this.stop = true;
            }
        } else if (operation == Key.j || operation == Key.DOWN || operation == Key.DOWN_2 || operation == Key.ENTER) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                if (operation == Key.j) {
                    this.searchBuilder.append((char)operation.getFirstValue());
                    this.displayBottom();
                } else if (operation == Key.ENTER) {
                    this.search = TerminalPage.Search.RESULT;
                    this.findSearchWord(true);
                }
            } else if (this.search == TerminalPage.Search.NOT_FOUND) {
                if (operation == Key.ENTER) {
                    this.search = TerminalPage.Search.NO_SEARCH;
                    this.clearBottomLine();
                    this.displayBottom();
                }
            } else {
                this.topVisibleRow += this.getNumber();
                if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                } else {
                    this.display();
                }
                this.clearNumber();
            }
        } else if (operation == Key.k || operation == Key.UP || operation == Key.UP_2) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                if (operation == Key.k) {
                    this.searchBuilder.append((char)operation.getFirstValue());
                }
                this.displayBottom();
            } else {
                this.topVisibleRow -= this.getNumber();
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display();
                this.clearNumber();
            }
        } else if (operation == Key.CTRL_F || operation == Key.PGDOWN || operation == Key.SPACE) {
            if (this.search != TerminalPage.Search.SEARCHING) {
                this.topVisibleRow += (this.rows - 1) * this.getNumber();
                if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                } else {
                    this.display();
                }
                this.clearNumber();
            }
        } else if (operation == Key.CTRL_B || operation == Key.PGUP) {
            if (this.search != TerminalPage.Search.SEARCHING) {
                this.topVisibleRow -= (this.rows - 1) * this.getNumber();
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display();
                this.clearNumber();
            }
        } else if (operation == Key.SLASH) {
            if (this.search == TerminalPage.Search.NO_SEARCH || this.search == TerminalPage.Search.RESULT) {
                this.search = TerminalPage.Search.SEARCHING;
                this.searchBuilder = new StringBuilder();
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getFirstValue());
                this.displayBottom();
            }
        } else if (operation == Key.n) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getFirstValue());
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.RESULT) {
                if (this.searchLines.size() > 0) {
                    for (Integer i : this.searchLines) {
                        if (i <= this.topVisibleRow + 1) continue;
                        this.topVisibleRow = i - 1;
                        this.display();
                        return;
                    }
                    this.displayBottom();
                } else {
                    this.displayBottom();
                }
            }
        } else if (operation == Key.N) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getFirstValue());
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.RESULT && this.searchLines.size() > 0) {
                for (int i = this.searchLines.size() - 1; i >= 0; --i) {
                    if (this.searchLines.get(i) >= this.topVisibleRow) continue;
                    this.topVisibleRow = this.searchLines.get(i) - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                    return;
                }
                this.displayBottom();
            }
        } else if (operation == Key.G) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getFirstValue());
                this.displayBottom();
            } else {
                if (this.number.length() == 0 || this.getNumber() == 0) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    this.display();
                } else {
                    this.topVisibleRow = this.getNumber() - 1;
                    if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                        this.topVisibleRow = this.page.size() - this.rows - 1;
                        this.display();
                    } else {
                        this.display();
                    }
                }
                this.clearNumber();
            }
        } else if (operation.isNumber()) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getFirstValue());
                this.displayBottom();
            } else {
                this.number.append(Character.getNumericValue(operation.getFirstValue()));
                this.display();
            }
        } else if (this.search == TerminalPage.Search.SEARCHING && Character.isAlphabetic(operation.getFirstValue())) {
            this.searchBuilder.append((char)operation.getFirstValue());
            this.displayBottom();
        }
    }

    private void display() throws IOException {
        if (this.topVisibleRow != this.topVisibleRowCache) {
            this.getShell().clear();
            if (this.search == TerminalPage.Search.RESULT && this.searchLines.size() > 0) {
                String searchWord = this.searchBuilder.toString();
                for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows - 1; ++i) {
                    if (i >= this.page.size()) continue;
                    String line = this.page.getLine(i);
                    if (line.contains(searchWord)) {
                        this.displaySearchLine(line, searchWord);
                    } else {
                        this.getShell().write(line);
                    }
                    this.getShell().write(Config.getLineSeparator());
                }
                this.topVisibleRowCache = this.topVisibleRow;
            } else {
                for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows - 1; ++i) {
                    if (i >= this.page.size()) continue;
                    this.getShell().write(this.page.getLine(i) + Config.getLineSeparator());
                }
                this.topVisibleRowCache = this.topVisibleRow;
            }
            this.displayBottom();
        }
    }

    private void displaySearchLine(String line, String searchWord) throws IOException {
        int start = line.indexOf(searchWord);
        this.getShell().write(line.substring(0, start));
        this.getShell().write(ANSI.INVERT_BACKGROUND);
        this.getShell().write(searchWord);
        this.getShell().write("\u001b[0m");
        this.getShell().write(line.substring(start + searchWord.length(), line.length()));
    }

    public abstract FileParser getFileParser();

    public abstract void displayBottom() throws IOException;

    public void writeToConsole(String word) throws IOException {
        this.getShell().write(word);
    }

    public void clearBottomLine() throws IOException {
        this.getShell().write(ANSI.printAnsi("0G"));
        this.getShell().write(ANSI.printAnsi("2K"));
    }

    public boolean isAtBottom() {
        return this.topVisibleRow >= this.page.size() - this.rows - 1;
    }

    public boolean isAtTop() {
        return this.topVisibleRow == 0;
    }

    public TerminalPage.Search getSearchStatus() {
        return this.search;
    }

    public String getSearchWord() {
        return this.searchBuilder.toString();
    }

    public int getTopVisibleRow() {
        return this.topVisibleRow + 1;
    }

    private void findSearchWord(boolean forward) throws IOException {
        LOGGER.info("searching for: " + this.searchBuilder.toString());
        this.searchLines = this.page.findWord(this.searchBuilder.toString());
        LOGGER.info("found: " + this.searchLines);
        if (this.searchLines.size() > 0) {
            for (Integer i : this.searchLines) {
                if (i <= this.topVisibleRow) continue;
                this.topVisibleRow = i - 1;
                this.display();
                return;
            }
        } else {
            this.search = TerminalPage.Search.NOT_FOUND;
            this.displayBottom();
        }
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

