/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.utils.AddressUtils;

public class AddressValidator
extends ModelTypeValidator {
    public AddressValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions, true);
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            String address = value.asString();
            if (address.startsWith("[") && address.endsWith("]")) {
                address = address.substring(1, address.length() - 1);
            }
            if (!AddressUtils.isValidAddress((String)address)) {
                throw new OperationFailedException((Throwable)Messages.MESSAGES.invalidAddressProvided(address));
            }
        }
    }
}

