/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.RuntimeMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.RuntimeMXBeanReadResourceHandler;
import org.jboss.dmr.ModelType;

class RuntimeResourceDefinition
extends SimpleResourceDefinition {
    private static AttributeDefinition UPTIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"uptime", (ModelType)ModelType.LONG, (boolean)false).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition START_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"start-time", (ModelType)ModelType.LONG, (boolean)false).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition SYSTEM_PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("system-properties", true).setStorageRuntime()).setRuntimeServiceNotRequired()).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SYSTEM_PROPERTY})).build();
    private static AttributeDefinition INPUT_ARGUMENTS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("input-arguments").setStorageRuntime()).setRuntimeServiceNotRequired()).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.JVM})).setRequired(false)).build();
    private static AttributeDefinition VM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"vm-name", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition VM_VENDOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"vm-vendor", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition VM_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"vm-version", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition SPEC_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"spec-name", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition SPEC_VENDOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"spec-vendor", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition SPEC_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"spec-version", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition MANAGEMENT_SPEC_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-spec-version", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private static AttributeDefinition CLASS_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"class-path", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.JVM})).build();
    private static AttributeDefinition LIBRARY_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"library-path", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.JVM})).build();
    private static AttributeDefinition BOOT_CLASS_PATH_SUPPORTED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"boot-class-path-supported", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).setRuntimeServiceNotRequired()).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.JVM})).build();
    private static AttributeDefinition BOOT_CLASS_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"boot-class-path", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.JVM})).build();
    private static final List<AttributeDefinition> METRICS = Arrays.asList(UPTIME);
    private static final List<AttributeDefinition> READ_ATTRIBUTES = Arrays.asList(PlatformMBeanConstants.NAME, VM_NAME, VM_VENDOR, VM_VERSION, SPEC_NAME, SPEC_VENDOR, SPEC_VERSION, MANAGEMENT_SPEC_VERSION, CLASS_PATH, LIBRARY_PATH, BOOT_CLASS_PATH_SUPPORTED, BOOT_CLASS_PATH, INPUT_ARGUMENTS, START_TIME, SYSTEM_PROPERTIES);
    public static final List<String> RUNTIME_READ_ATTRIBUTES = Arrays.asList(PlatformMBeanConstants.NAME.getName(), VM_NAME.getName(), VM_VENDOR.getName(), VM_VERSION.getName(), SPEC_NAME.getName(), SPEC_VENDOR.getName(), SPEC_VERSION.getName(), MANAGEMENT_SPEC_VERSION.getName(), CLASS_PATH.getName(), LIBRARY_PATH.getName(), BOOT_CLASS_PATH_SUPPORTED.getName(), BOOT_CLASS_PATH.getName(), INPUT_ARGUMENTS.getName(), START_TIME.getName(), SYSTEM_PROPERTIES.getName());
    public static final List<String> RUNTIME_METRICS = Arrays.asList(UPTIME.getName());
    static final RuntimeResourceDefinition INSTANCE = new RuntimeResourceDefinition();

    private RuntimeResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PlatformMBeanConstants.RUNTIME_PATH, (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("runtime")).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        super.registerAttributes(registration);
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute((AttributeDefinition)PlatformMBeanConstants.OBJECT_NAME, (OperationStepHandler)RuntimeMXBeanAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition attribute : READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)RuntimeMXBeanAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition attribute : METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)RuntimeMXBeanAttributeHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(ReadResourceHandler.DEFINITION, (OperationStepHandler)RuntimeMXBeanReadResourceHandler.INSTANCE);
    }
}

