/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.persistence;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Function;
import org.wildfly.clustering.infinispan.spi.persistence.IndexedKeyFormatMapper;
import org.wildfly.clustering.infinispan.spi.persistence.KeyFormat;
import org.wildfly.clustering.infinispan.spi.persistence.SimpleKeyFormat;

public class DynamicKeyFormatMapper
extends IndexedKeyFormatMapper {
    public DynamicKeyFormatMapper(ClassLoader loader) {
        super(DynamicKeyFormatMapper.load(loader));
    }

    private static List<KeyFormat<?>> load(ClassLoader loader) {
        LinkedList<KeyFormat> keyFormats = new LinkedList<KeyFormat>();
        for (KeyFormat keyFormat : ServiceLoader.load(KeyFormat.class, loader)) {
            keyFormats.add(keyFormat);
        }
        ArrayList result = new ArrayList(keyFormats.size() + 6);
        result.add(new SimpleKeyFormat<String>(String.class, Function.identity()));
        result.add(new SimpleKeyFormat<Byte>(Byte.class, Byte::valueOf));
        result.add(new SimpleKeyFormat<Short>(Short.class, Short::valueOf));
        result.add(new SimpleKeyFormat<Integer>(Integer.class, Integer::valueOf));
        result.add(new SimpleKeyFormat<Long>(Long.class, Long::valueOf));
        result.add(new SimpleKeyFormat<UUID>(UUID.class, UUID::fromString));
        result.addAll(keyFormats);
        return result;
    }
}

