/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.QueueQueryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.utils.BufferHelper;

public class SessionQueueQueryResponseMessage_V3
extends SessionQueueQueryResponseMessage_V2 {
    protected boolean autoCreated;
    protected boolean purgeOnNoConsumers;
    protected RoutingType routingType;
    protected int maxConsumers;
    protected Boolean exclusive;
    protected Boolean lastValue;

    public SessionQueueQueryResponseMessage_V3(QueueQueryResult result) {
        this(result.getName(), result.getAddress(), result.isDurable(), result.isTemporary(), result.getFilterString(), result.getConsumerCount(), result.getMessageCount(), result.isExists(), result.isAutoCreateQueues(), result.isAutoCreated(), result.isPurgeOnNoConsumers(), result.getRoutingType(), result.getMaxConsumers(), result.isExclusive(), result.isLastValue());
    }

    public SessionQueueQueryResponseMessage_V3() {
        this(null, null, false, false, null, 0, 0L, false, false, false, false, RoutingType.MULTICAST, -1, null, null);
    }

    private SessionQueueQueryResponseMessage_V3(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, long messageCount, boolean exists, boolean autoCreateQueues, boolean autoCreated, boolean purgeOnNoConsumers, RoutingType routingType, int maxConsumers, Boolean exclusive, Boolean lastValue) {
        super((byte)-14);
        this.durable = durable;
        this.temporary = temporary;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.filterString = filterString;
        this.address = address;
        this.name = name;
        this.exists = exists;
        this.autoCreateQueues = autoCreateQueues;
        this.autoCreated = autoCreated;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.routingType = routingType;
        this.maxConsumers = maxConsumers;
        this.exclusive = exclusive;
        this.lastValue = lastValue;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public void setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
    }

    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public void setPurgeOnNoConsumers(boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    public Boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public Boolean isLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Boolean lastValue) {
        this.lastValue = lastValue;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.autoCreated);
        buffer.writeBoolean(this.purgeOnNoConsumers);
        buffer.writeByte(this.routingType.getType());
        buffer.writeInt(this.maxConsumers);
        BufferHelper.writeNullableBoolean(buffer, this.exclusive);
        BufferHelper.writeNullableBoolean(buffer, this.lastValue);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.autoCreated = buffer.readBoolean();
        this.purgeOnNoConsumers = buffer.readBoolean();
        this.routingType = RoutingType.getType((byte)buffer.readByte());
        this.maxConsumers = buffer.readInt();
        if (buffer.readableBytes() > 0) {
            this.exclusive = BufferHelper.readNullableBoolean(buffer);
            this.lastValue = BufferHelper.readNullableBoolean(buffer);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoCreated ? 1231 : 1237);
        result = 31 * result + (this.purgeOnNoConsumers ? 1231 : 1237);
        result = 31 * result + this.routingType.hashCode();
        result = 31 * result + this.maxConsumers;
        result = 31 * result + (this.exclusive == null ? 0 : (this.exclusive != false ? 1231 : 1237));
        result = 31 * result + (this.lastValue == null ? 0 : (this.lastValue != false ? 1231 : 1237));
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append("]");
        return buff.toString();
    }

    @Override
    public String getParentString() {
        StringBuffer buff = new StringBuffer(super.getParentString());
        buff.append(", autoCreated=" + this.autoCreated);
        buff.append(", purgeOnNoConsumers=" + this.purgeOnNoConsumers);
        buff.append(", routingType=" + this.routingType);
        buff.append(", maxConsumers=" + this.maxConsumers);
        buff.append(", exclusive=" + this.exclusive);
        buff.append(", lastValue=" + this.lastValue);
        return buff.toString();
    }

    @Override
    public ClientSession.QueueQuery toQueueQuery() {
        return new QueueQueryImpl(this.isDurable(), this.isTemporary(), this.getConsumerCount(), this.getMessageCount(), this.getFilterString(), this.getAddress(), this.getName(), this.isExists(), this.isAutoCreateQueues(), this.getMaxConsumers(), this.isAutoCreated(), this.isPurgeOnNoConsumers(), this.getRoutingType(), this.isExclusive(), this.isLastValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryResponseMessage_V3)) {
            return false;
        }
        SessionQueueQueryResponseMessage_V3 other = (SessionQueueQueryResponseMessage_V3)obj;
        if (this.autoCreated != other.autoCreated) {
            return false;
        }
        if (this.purgeOnNoConsumers != other.purgeOnNoConsumers) {
            return false;
        }
        if (this.exclusive == null ? other.exclusive != null : !this.exclusive.equals(other.exclusive)) {
            return false;
        }
        if (this.lastValue == null ? other.lastValue != null : !this.lastValue.equals(other.lastValue)) {
            return false;
        }
        if (this.routingType == null ? other.routingType != null : !this.routingType.equals((Object)other.routingType)) {
            return false;
        }
        return this.maxConsumers == other.maxConsumers;
    }
}

