/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.util.Date;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;

public class TimerTask<T extends TimerImpl>
implements Runnable {
    protected final String timedObjectId;
    protected final String timerId;
    protected final TimerServiceImpl timerService;
    private volatile boolean cancelled = false;

    public TimerTask(T timer) {
        if (timer == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.timerIsNull();
        }
        this.timedObjectId = ((TimerImpl)timer).getTimedObjectId();
        this.timerId = ((TimerImpl)timer).getId();
        this.timerService = ((TimerImpl)timer).getTimerService();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void scheduleTimeoutIfRequired(TimerImpl timer) {
    }

    protected void callTimeout(TimerImpl timer) throws Exception {
        this.invokeBeanMethod(timer);
    }

    protected void invokeBeanMethod(TimerImpl timer) throws Exception {
        this.timerService.getInvoker().callTimeout(timer);
    }

    protected Date calculateNextTimeout(TimerImpl timer) {
        long intervalDuration = timer.getInterval();
        if (intervalDuration > 0L) {
            long now = new Date().getTime();
            long nextExpiration = timer.getNextExpiration().getTime();
            int periods = (int)((now - nextExpiration) / intervalDuration);
            return new Date(nextExpiration + (long)periods * intervalDuration + intervalDuration);
        }
        return null;
    }

    protected void retryTimeout(TimerImpl timer) throws Exception {
        boolean callTimeout = false;
        timer.lock();
        try {
            if (timer.isActive()) {
                EjbLogger.EJB3_TIMER_LOGGER.retryingTimeout(timer);
                timer.setTimerState(TimerState.RETRY_TIMEOUT);
                this.timerService.persistTimer(timer, false);
                callTimeout = true;
            } else {
                EjbLogger.EJB3_TIMER_LOGGER.timerNotActive(timer);
            }
        }
        finally {
            timer.unlock();
        }
        if (callTimeout) {
            this.callTimeout(timer);
        }
    }

    protected void postTimeoutProcessing(TimerImpl timer) throws InterruptedException {
        timer.lock();
        try {
            TimerState timerState = timer.getState();
            if (timerState != TimerState.CANCELED && timerState != TimerState.EXPIRED) {
                if (timer.getInterval() == 0L) {
                    this.timerService.expireTimer(timer);
                } else {
                    timer.setTimerState(TimerState.ACTIVE);
                }
                this.timerService.persistTimer(timer, false);
            }
        }
        finally {
            timer.unlock();
        }
    }

    public void cancel() {
        this.cancelled = true;
    }
}

