/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp.v11;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.FrameEventListener;
import org.apache.activemq.artemis.core.protocol.stomp.SimpleBytes;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompDecoder;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.VersionedStompFrameHandler;
import org.apache.activemq.artemis.core.protocol.stomp.v11.StompFrameV11;
import org.apache.activemq.artemis.core.remoting.server.impl.RemotingServiceImpl;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public class StompFrameHandlerV11
extends VersionedStompFrameHandler
implements FrameEventListener {
    protected static final char ESC_CHAR = '\\';
    private HeartBeater heartBeater;

    public StompFrameHandlerV11(StompConnection connection, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        super(connection, scheduledExecutorService, executorFactory);
        connection.addStompEventListener(this);
        this.decoder = new StompDecoderV11(this);
        this.decoder.init();
    }

    public ActiveMQScheduledComponent getHeartBeater() {
        return this.heartBeater;
    }

    @Override
    public StompFrame onConnect(StompFrame frame) {
        StompFrame response = null;
        Map<String, String> headers = frame.getHeadersMap();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientID = headers.get("client-id");
        String requestID = headers.get("request-id");
        try {
            this.connection.setClientID(clientID);
            if (this.connection.validateUser(login, passcode, this.connection)) {
                String heartBeat;
                this.connection.setValid(true);
                this.connection.getSession();
                response = this.createStompFrame("CONNECTED");
                response.addHeader("version", this.connection.getVersion());
                response.addHeader("session", this.connection.getID().toString());
                response.addHeader("server", this.connection.getActiveMQServerName());
                if (requestID != null) {
                    response.addHeader("response-id", requestID);
                }
                if ((heartBeat = headers.get("heart-beat")) != null) {
                    this.handleHeartBeat(heartBeat);
                    if (this.heartBeater == null) {
                        response.addHeader("heart-beat", "0,0");
                    } else {
                        response.addHeader("heart-beat", this.heartBeater.serverPingPeriod + "," + this.heartBeater.clientPingResponse);
                    }
                }
            } else {
                response = this.createStompFrame("ERROR");
                response.setNeedsDisconnect(true);
                response.addHeader("content-type", "text/plain");
                String responseText = "Security Error occurred: User name [" + login + "] or password is invalid";
                response.setBody(responseText);
                response.addHeader("message", responseText);
            }
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    private void handleHeartBeat(String heartBeatHeader) throws ActiveMQStompException {
        String[] params = heartBeatHeader.split(",");
        if (params.length != 2) {
            throw new ActiveMQStompException(this.connection, "Incorrect heartbeat header " + heartBeatHeader);
        }
        long minPingInterval = Long.valueOf(params[0]);
        long minAcceptInterval = Long.valueOf(params[1]);
        if (this.heartBeater == null) {
            this.heartBeater = new HeartBeater(this.scheduledExecutorService, (Executor)this.executorFactory.getExecutor(), minPingInterval, minAcceptInterval);
        }
    }

    @Override
    public StompFrame onDisconnect(StompFrame frame) {
        this.disconnect();
        return null;
    }

    @Override
    protected void disconnect() {
        if (this.heartBeater != null) {
            this.heartBeater.shutdown();
        }
    }

    @Override
    public StompFrame onUnsubscribe(StompFrame request) {
        StompFrame response = null;
        String id = request.getHeader("id");
        String durableSubscriptionName = request.getHeader("durable-subscriber-name");
        if (durableSubscriptionName == null) {
            durableSubscriptionName = request.getHeader("durable-subscription-name");
        }
        if (durableSubscriptionName == null) {
            durableSubscriptionName = request.getHeader("activemq.subscriptionName");
        }
        String subscriptionID = null;
        if (id != null) {
            subscriptionID = id;
        } else if (durableSubscriptionName == null) {
            response = ActiveMQStompProtocolMessageBundle.BUNDLE.needSubscriptionID().setHandler(this).getFrame();
            return response;
        }
        try {
            this.connection.unsubscribe(subscriptionID, durableSubscriptionName);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onAck(StompFrame request) {
        StompFrame response = null;
        String messageID = request.getHeader("message-id");
        String txID = request.getHeader("transaction");
        String subscriptionID = request.getHeader("subscription");
        if (txID != null) {
            ActiveMQServerLogger.LOGGER.stompTXAckNorSupported();
        }
        if (subscriptionID == null) {
            response = ActiveMQStompProtocolMessageBundle.BUNDLE.needSubscriptionID().setHandler(this).getFrame();
            return response;
        }
        try {
            this.connection.acknowledge(messageID, subscriptionID);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onStomp(StompFrame request) {
        if (!this.connection.isValid()) {
            return this.onConnect(request);
        }
        return null;
    }

    @Override
    public StompFrame onNack(StompFrame request) {
        return this.onAck(request);
    }

    @Override
    public void replySent(StompFrame reply) {
        if (reply.getCommand().equals("CONNECTED")) {
            this.startHeartBeat();
        }
        if (reply.needsDisconnect()) {
            this.connection.disconnect(false);
        } else if (this.heartBeater != null) {
            this.heartBeater.pinged();
        }
    }

    private void startHeartBeat() {
        if (this.heartBeater != null && this.heartBeater.serverPingPeriod != 0L) {
            this.heartBeater.start();
        }
    }

    public StompFrame createPingFrame() {
        StompFrame frame = this.createStompFrame("STOMP");
        frame.setPing(true);
        return frame;
    }

    @Override
    public void requestAccepted(StompFrame request) {
    }

    @Override
    public StompFrame createStompFrame(String command) {
        return new StompFrameV11(command);
    }

    @Override
    public void initDecoder(VersionedStompFrameHandler existingHandler) {
        this.decoder.init(existingHandler.getDecoder());
    }

    protected class StompDecoderV11
    extends StompDecoder {
        protected boolean isEscaping;
        protected SimpleBytes holder;

        public StompDecoderV11(StompFrameHandlerV11 handler) {
            super(handler);
            this.isEscaping = false;
            this.holder = new SimpleBytes(1024);
        }

        @Override
        public void init(StompDecoder decoder) {
            this.data = decoder.data;
            this.workingBuffer = decoder.workingBuffer;
            this.pos = decoder.pos;
            this.command = decoder.command;
        }

        @Override
        public void init() {
            super.init();
            this.isEscaping = false;
            this.holder.reset();
        }

        @Override
        protected boolean parseCommand() throws ActiveMQStompException {
            boolean nextChar;
            int offset;
            block38: {
                offset = 0;
                nextChar = false;
                do {
                    if (this.workingBuffer[offset] == 10) {
                        nextChar = false;
                        continue;
                    }
                    if (this.workingBuffer[offset] != 13) break block38;
                    if (nextChar) {
                        throw ActiveMQStompProtocolMessageBundle.BUNDLE.invalidTwoCRs().setHandler(this.handler);
                    }
                    nextChar = true;
                } while (++offset != this.data);
                return false;
            }
            if (nextChar) {
                throw ActiveMQStompProtocolMessageBundle.BUNDLE.badCRs().setHandler(this.handler);
            }
            if (offset > 0) {
                System.arraycopy(this.workingBuffer, offset, this.workingBuffer, 0, this.data - offset);
                this.data -= offset;
                offset = 0;
            }
            if (this.data < 4) {
                return false;
            }
            byte b = this.workingBuffer[offset];
            switch (b) {
                case 65: {
                    if (this.workingBuffer[offset + 1] == 66) {
                        if (!this.tryIncrement(offset + COMMAND_ABORT_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "ABORT";
                        break;
                    }
                    if (!this.tryIncrement(offset + COMMAND_ACK_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "ACK";
                    break;
                }
                case 66: {
                    if (!this.tryIncrement(offset + COMMAND_BEGIN_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "BEGIN";
                    break;
                }
                case 67: {
                    if (this.workingBuffer[offset + 2] == 77) {
                        if (!this.tryIncrement(offset + COMMAND_COMMIT_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "COMMIT";
                        break;
                    }
                    if (this.workingBuffer[offset + 7] == 69) {
                        if (!this.tryIncrement(offset + COMMAND_CONNECTED_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "CONNECTED";
                        break;
                    }
                    if (!this.tryIncrement(offset + COMMAND_CONNECT_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "CONNECT";
                    break;
                }
                case 68: {
                    if (!this.tryIncrement(offset + COMMAND_DISCONNECT_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "DISCONNECT";
                    break;
                }
                case 82: {
                    if (!this.tryIncrement(offset + COMMAND_RECEIPT_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "RECEIPT";
                    break;
                }
                case 69: {
                    if (!this.tryIncrement(offset + COMMAND_ERROR_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "ERROR";
                    break;
                }
                case 77: {
                    if (!this.tryIncrement(offset + COMMAND_MESSAGE_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "MESSAGE";
                    break;
                }
                case 83: {
                    if (this.workingBuffer[offset + 1] == 69) {
                        if (!this.tryIncrement(offset + COMMAND_SEND_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "SEND";
                        break;
                    }
                    if (this.workingBuffer[offset + 1] == 85) {
                        if (!this.tryIncrement(offset + COMMAND_SUBSCRIBE_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "SUBSCRIBE";
                        break;
                    }
                    if (!this.tryIncrement(offset + StompDecoder.COMMAND_STOMP_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "STOMP";
                    break;
                }
                case 85: {
                    if (!this.tryIncrement(offset + COMMAND_UNSUBSCRIBE_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "UNSUBSCRIBE";
                    break;
                }
                case 78: {
                    if (!this.tryIncrement(offset + COMMAND_NACK_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "NACK";
                    break;
                }
                default: {
                    this.throwInvalid();
                }
            }
            this.checkEol();
            return true;
        }

        protected void checkEol() throws ActiveMQStompException {
            if (this.workingBuffer[this.pos - 1] != 10) {
                this.throwInvalid();
            }
        }

        protected void throwUndefinedEscape(byte b) throws ActiveMQStompException {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.undefinedEscapeSequence(new String(new char[]{'\\', (char)b})).setHandler(this.handler);
            error.setCode(3);
            throw error;
        }

        @Override
        protected boolean parseHeaders() throws ActiveMQStompException {
            block16: {
                do {
                    byte b = this.workingBuffer[this.pos++];
                    switch (b) {
                        case 92: {
                            if (this.isEscaping) {
                                this.holder.append(b);
                                this.isEscaping = false;
                                break;
                            }
                            this.isEscaping = true;
                            break;
                        }
                        case 58: {
                            if (this.inHeaderName) {
                                this.headerName = this.holder.getString();
                                this.holder.reset();
                                this.inHeaderName = false;
                                this.headerValueWhitespace = true;
                            }
                            this.whiteSpaceOnly = false;
                            break;
                        }
                        case 110: {
                            if (this.isEscaping) {
                                this.holder.append((byte)10);
                                this.isEscaping = false;
                                break;
                            }
                            this.holder.append(b);
                            break;
                        }
                        case 99: {
                            if (this.isEscaping) {
                                this.holder.append((byte)58);
                                this.isEscaping = false;
                                break;
                            }
                            this.holder.append(b);
                            break;
                        }
                        case 10: {
                            if (this.whiteSpaceOnly) {
                                this.readingHeaders = false;
                                break block16;
                            }
                            String headerValue = this.holder.getString();
                            this.holder.reset();
                            this.headers.put(this.headerName, headerValue);
                            if (this.headerName.equals("content-length")) {
                                this.contentLength = Integer.parseInt(headerValue);
                            }
                            if (this.headerName.equals("content-type")) {
                                this.contentType = headerValue;
                            }
                            this.whiteSpaceOnly = true;
                            this.inHeaderName = true;
                            this.headerValueWhitespace = false;
                            break;
                        }
                        default: {
                            this.whiteSpaceOnly = false;
                            this.headerValueWhitespace = false;
                            if (this.isEscaping) {
                                this.throwUndefinedEscape(b);
                            }
                            this.holder.append(b);
                        }
                    }
                } while (this.pos != this.data);
                return false;
            }
            return true;
        }

        @Override
        protected StompFrame parseBody() throws ActiveMQStompException {
            byte[] content;
            block9: {
                block8: {
                    content = null;
                    if (this.contentLength == -1) break block8;
                    if (this.pos + this.contentLength + 1 > this.data) break block9;
                    content = new byte[this.contentLength];
                    System.arraycopy(this.workingBuffer, this.pos, content, 0, this.contentLength);
                    this.pos += this.contentLength;
                    if (this.bodyStart == -1) {
                        this.bodyStart = this.pos;
                    }
                    while (this.pos < this.data && this.workingBuffer[this.pos++] != 0) {
                    }
                    break block9;
                }
                if (this.bodyStart == -1) {
                    this.bodyStart = this.pos;
                }
                while (this.pos < this.data) {
                    if (this.workingBuffer[this.pos++] != 0) continue;
                    content = new byte[this.pos - this.bodyStart - 1];
                    System.arraycopy(this.workingBuffer, this.bodyStart, content, 0, content.length);
                    break;
                }
            }
            if (content != null) {
                if (this.data > this.pos) {
                    if (this.workingBuffer[this.pos] == 10) {
                        ++this.pos;
                    }
                    if (this.data > this.pos) {
                        System.arraycopy(this.workingBuffer, this.pos, this.workingBuffer, 0, this.data - this.pos);
                    }
                }
                this.data -= this.pos;
                StompFrameV11 ret = new StompFrameV11(this.command, this.headers, content);
                this.init();
                return ret;
            }
            return null;
        }
    }

    private class HeartBeater
    extends ActiveMQScheduledComponent {
        private static final int MIN_SERVER_PING = 500;
        long serverPingPeriod;
        long clientPingResponse;
        volatile boolean shutdown;
        AtomicLong lastPingTimestamp;
        ConnectionEntry connectionEntry;

        private HeartBeater(ScheduledExecutorService scheduledExecutorService, Executor executor, long clientPing, long clientAcceptPing) {
            super(scheduledExecutorService, executor, clientAcceptPing > 500L ? clientAcceptPing : 500L, TimeUnit.MILLISECONDS, false);
            this.serverPingPeriod = 0L;
            this.shutdown = false;
            this.lastPingTimestamp = new AtomicLong(0L);
            if (clientAcceptPing != 0L) {
                this.serverPingPeriod = super.getPeriod();
            }
            this.connectionEntry = ((RemotingServiceImpl)StompFrameHandlerV11.this.connection.getManager().getServer().getRemotingService()).getConnectionEntry(StompFrameHandlerV11.this.connection.getID());
            if (this.connectionEntry != null) {
                String heartBeatToTtlModifierStr = (String)StompFrameHandlerV11.this.connection.getAcceptorUsed().getConfiguration().get("heartBeatToConnectionTtlModifier");
                double heartBeatToTtlModifier = heartBeatToTtlModifierStr == null ? 2.0 : Double.valueOf(heartBeatToTtlModifierStr);
                this.clientPingResponse = (long)((double)this.connectionEntry.ttl / heartBeatToTtlModifier);
                if (clientPing != 0L) {
                    this.clientPingResponse = clientPing;
                    String ttlMaxStr = (String)StompFrameHandlerV11.this.connection.getAcceptorUsed().getConfiguration().get("connectionTtlMax");
                    long ttlMax = ttlMaxStr == null ? Long.MAX_VALUE : Long.valueOf(ttlMaxStr);
                    long connectionTtl = (long)((double)clientPing * heartBeatToTtlModifier);
                    String ttlMinStr = (String)StompFrameHandlerV11.this.connection.getAcceptorUsed().getConfiguration().get("connectionTtlMin");
                    long ttlMin = ttlMinStr == null ? 1000L : Long.valueOf(ttlMinStr);
                    if (connectionTtl < ttlMin) {
                        connectionTtl = ttlMin;
                        this.clientPingResponse = (long)((double)ttlMin / heartBeatToTtlModifier);
                    } else if (connectionTtl > ttlMax) {
                        connectionTtl = ttlMax;
                        this.clientPingResponse = (long)((double)ttlMax / heartBeatToTtlModifier);
                    }
                    if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                        ActiveMQServerLogger.LOGGER.debug((Object)("Setting STOMP client TTL to: " + connectionTtl));
                    }
                    this.connectionEntry.ttl = connectionTtl;
                }
            }
        }

        public void shutdown() {
            this.stop();
        }

        public void pinged() {
            this.lastPingTimestamp.set(System.currentTimeMillis());
        }

        public void run() {
            this.lastPingTimestamp.set(System.currentTimeMillis());
            StompFrameHandlerV11.this.connection.ping(StompFrameHandlerV11.this.createPingFrame());
        }
    }
}

