/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import javax.jms.Queue;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ExternalJMSQueueService
implements Service<Queue> {
    static final String JMS_QUEUE_PREFIX = "jms.queue.";
    private final String queueName;
    private Queue queue;

    public ExternalJMSQueueService(String queueName) {
        this.queueName = queueName;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.queue = ActiveMQJMSClient.createQueue((String)(JMS_QUEUE_PREFIX + this.queueName));
    }

    public synchronized void stop(StopContext context) {
        this.queue = null;
    }

    public Queue getValue() throws IllegalStateException, IllegalArgumentException {
        return this.queue;
    }

    public static Service<Queue> installService(String name, ServiceTarget serviceTarget, ServiceName serviceName) {
        ExternalJMSQueueService service = new ExternalJMSQueueService(name);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        serviceBuilder.install();
        return service;
    }
}

