/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.SavedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.elytron.web.undertow.server.ScopeSessionListener;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.Scope;

class ElytronHttpServletExchange
extends ElytronHttpExchange {
    private static final Logger log = Logger.getLogger((String)"org.wildfly.security.http.servlet");
    private final HttpServerExchange httpServerExchange;
    private final ScopeSessionListener scopeSessionListener;
    static Function<HttpServerExchange, HttpScope> APPLICATION_SCOPE_RESOLVER = ElytronHttpServletExchange::applicationScope;

    protected ElytronHttpServletExchange(HttpServerExchange httpServerExchange, ScopeSessionListener scopeSessionListener) {
        super(httpServerExchange);
        this.httpServerExchange = httpServerExchange;
        this.scopeSessionListener = scopeSessionListener;
    }

    protected SessionManager getSessionManager() {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return servletRequestContext.getDeployment().getSessionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getRequestParameters() {
        if (this.requestParameters == null) {
            ElytronHttpServletExchange elytronHttpServletExchange = this;
            synchronized (elytronHttpServletExchange) {
                HashMap requestParameters;
                ServletRequestContext servletRequestContext = (ServletRequestContext)this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                ServletRequest servletRequest = servletRequestContext.getServletRequest();
                if (servletRequest instanceof HttpServletRequest) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                    Map parameters = httpServletRequest.getParameterMap();
                    requestParameters = new HashMap(parameters.size());
                    for (Map.Entry entry : parameters.entrySet()) {
                        requestParameters.put(entry.getKey(), Collections.unmodifiableList(Arrays.asList((Object[])entry.getValue())));
                    }
                } else {
                    return super.getRequestParameters();
                }
                this.requestParameters = Collections.unmodifiableMap(requestParameters);
            }
        }
        return this.requestParameters;
    }

    protected SessionConfig getSessionConfig() {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return servletRequestContext.getCurrentServletContext().getSessionConfig();
    }

    public int forward(String path) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest req = servletRequestContext.getServletRequest();
        ServletResponse resp = servletRequestContext.getServletResponse();
        RequestDispatcher disp = req.getRequestDispatcher(path);
        if (disp == null) {
            return super.forward(path);
        }
        FormResponseWrapper respWrapper = this.httpServerExchange.getStatusCode() != 200 && resp instanceof HttpServletResponse ? new FormResponseWrapper((HttpServletResponse)resp) : null;
        try {
            disp.forward(req, (ServletResponse)(respWrapper != null ? respWrapper : resp));
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return respWrapper != null ? respWrapper.getStatus() : this.httpServerExchange.getStatusCode();
    }

    public boolean suspendRequest() {
        SavedRequest.trySaveRequest((HttpServerExchange)this.httpServerExchange);
        return true;
    }

    public boolean resumeRequest() {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpSessionImpl session = servletRequestContext.getCurrentServletContext().getSession(this.httpServerExchange, false);
        if (session != null) {
            SavedRequest.tryRestoreRequest((HttpServerExchange)this.httpServerExchange, (HttpSession)session);
        }
        return true;
    }

    public HttpScope getScope(Scope scope) {
        switch (scope) {
            case APPLICATION: {
                return ElytronHttpServletExchange.applicationScope(this.httpServerExchange);
            }
            case EXCHANGE: {
                return ElytronHttpServletExchange.requestScope(this.httpServerExchange);
            }
            case SESSION: {
                return ElytronHttpServletExchange.sessionScope(this.httpServerExchange, this.scopeSessionListener);
            }
        }
        return super.getScope(scope);
    }

    private static HttpScope applicationScope(HttpServerExchange exchange) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (servletRequestContext != null) {
            final Deployment deployment = servletRequestContext.getDeployment();
            ServletContextImpl servletContext = deployment.getServletContext();
            return new HttpScope((ServletContext)servletContext){
                final /* synthetic */ ServletContext val$servletContext;
                {
                    this.val$servletContext = servletContext;
                }

                public String getID() {
                    return deployment.getDeploymentInfo().getDeploymentName();
                }

                public boolean supportsAttachments() {
                    return true;
                }

                public void setAttachment(String key, Object value) {
                    this.val$servletContext.setAttribute(key, value);
                }

                public Object getAttachment(String key) {
                    return this.val$servletContext.getAttribute(key);
                }

                public boolean supportsResources() {
                    return true;
                }

                public InputStream getResource(String path) {
                    return this.val$servletContext.getResourceAsStream(path);
                }
            };
        }
        return null;
    }

    private static HttpScope requestScope(HttpServerExchange exchange) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (servletRequestContext != null) {
            final ServletRequest servletRequest = servletRequestContext.getServletRequest();
            return new HttpScope(){

                public boolean supportsAttachments() {
                    return true;
                }

                public void setAttachment(String key, Object value) {
                    servletRequest.setAttribute(key, value);
                }

                public Object getAttachment(String key) {
                    return servletRequest.getAttribute(key);
                }
            };
        }
        return null;
    }

    private static HttpScope sessionScope(HttpServerExchange exchange, final ScopeSessionListener listener) {
        final ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return new HttpScope(){
            private HttpSession session;
            {
                this.session = context.getOriginalRequest().getSession(false);
            }

            public String getID() {
                return this.exists() ? this.session.getId() : null;
            }

            public boolean exists() {
                return this.session != null;
            }

            public synchronized boolean create() {
                if (this.exists()) {
                    return false;
                }
                this.session = context.getOriginalRequest().getSession(true);
                return this.session != null;
            }

            public boolean supportsAttachments() {
                return true;
            }

            public void setAttachment(String key, Object value) {
                if (this.exists()) {
                    this.session.setAttribute(key, value);
                }
            }

            public Object getAttachment(String key) {
                return this.exists() ? this.session.getAttribute(key) : null;
            }

            public boolean supportsInvalidation() {
                return true;
            }

            public boolean invalidate() {
                if (this.exists()) {
                    try {
                        this.session.invalidate();
                        return true;
                    }
                    catch (IllegalStateException cause) {
                        log.debugf("Failed to invalidate session", (Object)cause);
                    }
                }
                return false;
            }

            public boolean supportsNotifications() {
                return true;
            }

            public void registerForNotification(Consumer<HttpScopeNotification> consumer) {
                if (this.exists()) {
                    listener.registerListener(this.session.getId(), consumer);
                }
            }
        };
    }

    private static class FormResponseWrapper
    extends HttpServletResponseWrapper {
        private int status = 200;

        private FormResponseWrapper(HttpServletResponse wrapped) {
            super(wrapped);
        }

        public void setStatus(int sc, String sm) {
            this.status = sc;
        }

        public void setStatus(int sc) {
            this.status = sc;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

