/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

class ManagedServerProxy
implements TransactionalProtocolClient {
    private static final TransactionalProtocolClient DISCONNECTED = new DisconnectedProtocolClient();
    private final ManagedServer server;
    private final Map<TransactionalProtocolClient, Set<AsyncFuture<OperationResponse>>> activeRequests = new HashMap<TransactionalProtocolClient, Set<AsyncFuture<OperationResponse>>>();
    private volatile TransactionalProtocolClient remoteClient;

    ManagedServerProxy(ManagedServer server) {
        this.server = server;
        this.remoteClient = DISCONNECTED;
    }

    synchronized void connected(TransactionalProtocolClient remoteClient) {
        this.remoteClient = remoteClient;
    }

    synchronized boolean disconnected(TransactionalProtocolClient old) {
        if (this.remoteClient == old) {
            this.remoteClient = DISCONNECTED;
            Set<AsyncFuture<OperationResponse>> inFlight = this.activeRequests.remove(old);
            if (inFlight != null) {
                for (AsyncFuture<OperationResponse> future : inFlight) {
                    future.asyncCancel(true);
                }
            }
            return true;
        }
        return false;
    }

    public AsyncFuture<OperationResponse> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
        return this.execute(listener, TransactionalProtocolHandlers.wrap((ModelNode)operation, (OperationMessageHandler)messageHandler, (OperationAttachments)attachments));
    }

    public <T extends TransactionalProtocolClient.Operation> AsyncFuture<OperationResponse> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
        String operationName;
        TransactionalProtocolClient remoteClient = this.remoteClient;
        ModelNode op = operation.getOperation();
        if (remoteClient == DISCONNECTED && "server-set-restart-required".equals(operationName = op.get("operation").asString())) {
            this.server.requireReload();
        }
        AsyncFuture future = remoteClient.execute(listener, operation);
        this.registerFuture(remoteClient, (AsyncFuture<OperationResponse>)future);
        return future;
    }

    private synchronized void registerFuture(TransactionalProtocolClient remoteClient, final AsyncFuture<OperationResponse> future) {
        if (this.remoteClient != remoteClient) {
            future.asyncCancel(true);
        } else {
            Set<AsyncFuture<OperationResponse>> futures = this.activeRequests.get(remoteClient);
            if (futures == null) {
                futures = new HashSet<AsyncFuture<OperationResponse>>();
                this.activeRequests.put(remoteClient, futures);
            }
            futures.add(future);
            future.addListener((AsyncFuture.Listener)new AsyncFuture.Listener<OperationResponse, TransactionalProtocolClient>(){

                public void handleComplete(AsyncFuture<? extends OperationResponse> ignored, TransactionalProtocolClient attachment) {
                    ManagedServerProxy.this.futureDone(attachment, (AsyncFuture<? extends OperationResponse>)future);
                }

                public void handleFailed(AsyncFuture<? extends OperationResponse> ignored, Throwable cause, TransactionalProtocolClient attachment) {
                    ManagedServerProxy.this.futureDone(attachment, (AsyncFuture<? extends OperationResponse>)future);
                }

                public void handleCancelled(AsyncFuture<? extends OperationResponse> ignored, TransactionalProtocolClient attachment) {
                    ManagedServerProxy.this.futureDone(attachment, (AsyncFuture<? extends OperationResponse>)future);
                }
            }, (Object)remoteClient);
        }
    }

    private synchronized void futureDone(TransactionalProtocolClient remoteClient, AsyncFuture<? extends OperationResponse> future) {
        Set<AsyncFuture<OperationResponse>> futures = this.activeRequests.get(remoteClient);
        if (futures != null) {
            futures.remove(future);
        }
    }

    static final class DisconnectedProtocolClient
    implements TransactionalProtocolClient {
        DisconnectedProtocolClient() {
        }

        public AsyncFuture<OperationResponse> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
            return this.execute(listener, TransactionalProtocolHandlers.wrap((ModelNode)operation, (OperationMessageHandler)messageHandler, (OperationAttachments)attachments));
        }

        public <T extends TransactionalProtocolClient.Operation> AsyncFuture<OperationResponse> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
            throw HostControllerLogger.ROOT_LOGGER.channelClosed();
        }
    }
}

