/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.picketlink.identity.federation.web.config.IdentityURLConfigurationProvider;

public class PropertiesIdentityURLProvider
implements IdentityURLConfigurationProvider {
    private ClassLoader classLoader = null;
    private ServletContext servletContext = null;
    public static final String PROP_FILE_NAME = "idpmap.properties";
    public static final String WEB_INF_PROP_FILE_NAME = "/WEB-INF/idpmap.properties";

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Map<String, String> getIDPMap() throws IOException {
        HashMap<String, String> idpmap = new HashMap<String, String>();
        InputStream inputStream = null;
        Properties properties = new Properties();
        if (this.classLoader != null) {
            inputStream = this.classLoader.getResourceAsStream(PROP_FILE_NAME);
        }
        if (inputStream == null && this.servletContext != null) {
            inputStream = this.servletContext.getResourceAsStream(PROP_FILE_NAME);
        }
        if (inputStream == null && this.servletContext != null) {
            inputStream = this.servletContext.getResourceAsStream(WEB_INF_PROP_FILE_NAME);
        }
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream(PROP_FILE_NAME);
        }
        if (inputStream != null) {
            properties.load(inputStream);
            if (properties != null) {
                Set<Object> keyset = properties.keySet();
                for (Object key : keyset) {
                    idpmap.put((String)key, (String)properties.get(key));
                }
            }
        }
        return idpmap;
    }
}

