/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.StreamCorruptedException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverUnmarshaller;

final class BlockUnmarshaller
implements Unmarshaller {
    private final RiverUnmarshaller riverUnmarshaller;
    private int remaining;

    BlockUnmarshaller(RiverUnmarshaller riverUnmarshaller) {
        this.riverUnmarshaller = riverUnmarshaller;
    }

    boolean inBlock() {
        return this.remaining > 0;
    }

    int remaining() {
        return this.remaining;
    }

    void endOfStream() {
        if (this.remaining != 0) {
            throw new IllegalStateException("Not at end of block");
        }
        this.remaining = -1;
    }

    int tempEndOfStream() {
        try {
            int n = this.remaining;
            return n;
        }
        finally {
            this.remaining = -1;
        }
    }

    void restore(int remaining) {
        this.remaining = remaining;
    }

    void unblock() {
        if (this.remaining == -1) {
            this.remaining = 0;
        }
    }

    void readBlockHeader(int leadByte) throws IOException {
        switch (leadByte) {
            case 50: {
                this.remaining = this.riverUnmarshaller.readUnsignedByte();
                return;
            }
            case 51: {
                this.remaining = this.riverUnmarshaller.readUnsignedShort();
                return;
            }
            case 52: {
                int len = this.riverUnmarshaller.readInt();
                if (len < 0) {
                    throw new StreamCorruptedException("Invalid block length");
                }
                this.remaining = len;
                return;
            }
            case 53: {
                this.remaining = -1;
                return;
            }
        }
        throw this.badLeadByte(leadByte);
    }

    void readToEndBlockData() throws IOException, ClassNotFoundException {
        block5: while (true) {
            if (this.remaining > 0) {
                this.skipBytes(this.remaining);
                continue;
            }
            int b = this.riverUnmarshaller.read();
            switch (b) {
                case -1: {
                    this.remaining = -1;
                    return;
                }
                case 53: {
                    this.remaining = -1;
                    return;
                }
                case 50: 
                case 51: 
                case 52: {
                    this.readBlockHeader(b);
                    continue block5;
                }
            }
            this.riverUnmarshaller.doReadObject(b, false, true);
        }
    }

    private StreamCorruptedException badLeadByte(int leadByte) {
        return new StreamCorruptedException("Unexpected lead byte " + leadByte);
    }

    public Object readObjectUnshared() throws ClassNotFoundException, IOException {
        return this.readObject(true);
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.readObject(false);
    }

    private Object readObject(boolean unshared) throws ClassNotFoundException, IOException {
        if (this.remaining > 0) {
            throw Marshalling.createOptionalDataException((int)this.remaining);
        }
        if (this.remaining == -1) {
            throw Marshalling.createOptionalDataException((boolean)true);
        }
        int leadByte = this.riverUnmarshaller.read();
        if (leadByte == -1 || leadByte == 53) {
            this.remaining = -1;
            throw Marshalling.createOptionalDataException((boolean)true);
        }
        return this.riverUnmarshaller.doReadObject(leadByte, unshared, false);
    }

    public int read() throws IOException {
        while (this.remaining == 0) {
            int v = this.riverUnmarshaller.read();
            if (v == -1) {
                return -1;
            }
            this.readBlockHeader(v);
        }
        if (this.remaining == -1) {
            return -1;
        }
        --this.remaining;
        return this.riverUnmarshaller.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        while (this.remaining == 0) {
            int v = this.riverUnmarshaller.read();
            if (v == -1) {
                return -1;
            }
            this.readBlockHeader(v);
        }
        int remaining = this.remaining;
        if (remaining == -1) {
            return -1;
        }
        int cnt = this.riverUnmarshaller.read(b, off, Math.min(remaining, len));
        this.remaining = remaining - cnt;
        return cnt;
    }

    public long skip(long n) throws IOException {
        while (this.remaining == 0) {
            int v = this.riverUnmarshaller.read();
            if (v == -1) {
                return -1L;
            }
            this.readBlockHeader(v);
        }
        int remaining = this.remaining;
        if (remaining == -1) {
            return -1L;
        }
        int cnt = this.riverUnmarshaller.skipBytes((int)Math.min((long)remaining, n));
        this.remaining = remaining - cnt;
        return cnt;
    }

    public int available() throws IOException {
        return Math.min(this.remaining, this.riverUnmarshaller.available());
    }

    public void readFully(byte[] b) throws IOException {
        Marshalling.readFully((ByteInput)this, (byte[])b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        Marshalling.readFully((ByteInput)this, (byte[])b, (int)off, (int)len);
    }

    public int skipBytes(int n) throws IOException {
        while (this.remaining == 0) {
            int v = this.riverUnmarshaller.read();
            if (v == -1) {
                return -1;
            }
            this.readBlockHeader(v);
        }
        int remaining = this.remaining;
        if (remaining == -1) {
            return -1;
        }
        int cnt = this.riverUnmarshaller.skipBytes(Math.min(remaining, n));
        this.remaining = remaining - cnt;
        return cnt;
    }

    public boolean readBoolean() throws IOException {
        while (this.remaining == 0) {
            this.readBlockHeader(this.riverUnmarshaller.readUnsignedByte());
        }
        if (this.remaining == -1) {
            throw new EOFException();
        }
        --this.remaining;
        return this.riverUnmarshaller.readBoolean();
    }

    public byte readByte() throws IOException {
        while (this.remaining == 0) {
            this.readBlockHeader(this.riverUnmarshaller.readUnsignedByte());
        }
        if (this.remaining == -1) {
            throw new EOFException();
        }
        --this.remaining;
        return this.riverUnmarshaller.readByte();
    }

    public int readUnsignedByte() throws IOException {
        while (this.remaining == 0) {
            this.readBlockHeader(this.riverUnmarshaller.readUnsignedByte());
        }
        if (this.remaining == -1) {
            throw new EOFException();
        }
        --this.remaining;
        return this.riverUnmarshaller.readUnsignedByte();
    }

    public short readShort() throws IOException {
        if (this.remaining < 2) {
            return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
        }
        this.remaining -= 2;
        return this.riverUnmarshaller.readShort();
    }

    public int readUnsignedShort() throws IOException {
        if (this.remaining < 2) {
            return this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }
        this.remaining -= 2;
        return this.riverUnmarshaller.readUnsignedShort();
    }

    public char readChar() throws IOException {
        if (this.remaining < 2) {
            return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
        }
        this.remaining -= 2;
        return this.riverUnmarshaller.readChar();
    }

    public int readInt() throws IOException {
        if (this.remaining < 4) {
            return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }
        this.remaining -= 4;
        return this.riverUnmarshaller.readInt();
    }

    public long readLong() throws IOException {
        if (this.remaining < 8) {
            return (long)this.readUnsignedByte() << 56 | (long)this.readUnsignedByte() << 48 | (long)this.readUnsignedByte() << 40 | (long)this.readUnsignedByte() << 32 | (long)this.readUnsignedByte() << 24 | (long)this.readUnsignedByte() << 16 | (long)this.readUnsignedByte() << 8 | (long)this.readUnsignedByte();
        }
        this.remaining -= 8;
        return this.riverUnmarshaller.readLong();
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine() is deprecated anyway!");
    }

    public String readUTF() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            throw new StreamCorruptedException("Invalid string length");
        }
        return UTFUtils.readUTFBytes((ByteInput)this, (int)len);
    }

    public void clearInstanceCache() throws IOException {
        throw new IllegalStateException("clearInstanceCache() may not be called in this context");
    }

    public void clearClassCache() throws IOException {
        throw new IllegalStateException("clearClassCache() may not be called in this context");
    }

    public void start(ByteInput newInput) throws IOException {
        throw new IllegalStateException("start() may not be called in this context");
    }

    public void finish() throws IOException {
        throw new IllegalStateException("finish() may not be called in this context");
    }

    public void close() throws IOException {
        throw new IllegalStateException("close() may not be called in this context");
    }

    public <T> T readObject(Class<T> type) throws ClassNotFoundException, IOException {
        Object obj = this.readObject(false);
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            throw BlockUnmarshaller.wrongType(e, type, obj.getClass());
        }
    }

    public <T> T readObjectUnshared(Class<T> type) throws ClassNotFoundException, IOException {
        Object obj = this.readObject(true);
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            throw BlockUnmarshaller.wrongType(e, type, obj.getClass());
        }
    }

    private static InvalidObjectException wrongType(ClassCastException e, Class<?> expected, Class<?> actual) {
        InvalidObjectException ioe = new InvalidObjectException("Object is of the wrong type (expected " + expected + ", got " + actual + ")");
        ioe.initCause(e);
        return ioe;
    }
}

