/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.executors.ManageableExecutorService;

public final class LazyInitializingExecutorService
extends ManageableExecutorService<ExecutorService>
implements ExecutorService {
    private final ThreadPoolExecutorFactory<ExecutorService> executorFactory;
    private final ThreadFactory threadFactory;

    public LazyInitializingExecutorService(ThreadPoolExecutorFactory<ExecutorService> executorFactory, ThreadFactory threadFactory) {
        this.executorFactory = executorFactory;
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (this.executor == null) {
            LazyInitializingExecutorService lazyInitializingExecutorService = this;
            synchronized (lazyInitializingExecutorService) {
                if (this.executor == null) {
                    this.executor = this.executorFactory.createExecutor(this.threadFactory);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.executor == null) {
            return Collections.emptyList();
        }
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor == null || this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor == null || this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executor == null) {
            return true;
        }
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.initIfNeeded();
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.initIfNeeded();
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.initIfNeeded();
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.initIfNeeded();
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.initIfNeeded();
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.initIfNeeded();
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.initIfNeeded();
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.initIfNeeded();
        this.executor.execute(command);
    }
}

