/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Collection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.NamingException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.service.NamingService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.jms.DestinationConfiguration;
import org.wildfly.extension.messaging.activemq.jms.ExternalPooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ExternalJMSQueueService
implements Service<Queue> {
    static final String JMS_QUEUE_PREFIX = "jms.queue.";
    private final String queueName;
    private final DestinationConfiguration config;
    private final InjectedValue<NamingStore> namingStoreInjector = new InjectedValue();
    private final InjectedValue<ExternalPooledConnectionFactoryService> pcfInjector = new InjectedValue();
    private Queue queue;
    private ClientSessionFactory sessionFactory;

    private ExternalJMSQueueService(String queueName) {
        this.queueName = JMS_QUEUE_PREFIX + queueName;
        this.config = null;
    }

    private ExternalJMSQueueService(DestinationConfiguration config) {
        this.queueName = JMS_QUEUE_PREFIX + config.getName();
        this.config = config;
    }

    public synchronized void start(StartContext context) throws StartException {
        NamingStore namingStore = (NamingStore)this.namingStoreInjector.getOptionalValue();
        if (namingStore != null) {
            final Queue managementQueue = this.config.getManagementQueue();
            NamingContext storeBaseContext = new NamingContext(namingStore, null);
            try {
                ConnectionFactory cf = (ConnectionFactory)storeBaseContext.lookup(((ExternalPooledConnectionFactoryService)this.pcfInjector.getValue()).getBindInfo().getAbsoluteJndiName());
                if (cf instanceof ActiveMQRAConnectionFactory) {
                    ActiveMQRAConnectionFactory raCf = (ActiveMQRAConnectionFactory)cf;
                    ServerLocator locator = raCf.getDefaultFactory().getServerLocator();
                    this.sessionFactory = locator.createSessionFactory();
                    ClusterTopologyListener listener = new ClusterTopologyListener(){

                        public void nodeUP(TopologyMember member, boolean last) {
                            Throwable throwable;
                            ActiveMQConnectionFactory factory;
                            try {
                                factory = new ActiveMQConnectionFactory(false, new TransportConfiguration[]{member.getLive()});
                                throwable = null;
                                try {
                                    MessagingLogger.ROOT_LOGGER.infof("Creating queue %s on node UP %s - %s", ExternalJMSQueueService.this.queueName, member.getNodeId(), member.getLive().toJson());
                                    ExternalJMSQueueService.this.config.createQueue((ConnectionFactory)factory, managementQueue, ExternalJMSQueueService.this.queueName);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (factory != null) {
                                        if (throwable != null) {
                                            try {
                                                factory.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                        } else {
                                            factory.close();
                                        }
                                    }
                                }
                            }
                            catch (JMSException | StartException ex) {
                                MessagingLogger.ROOT_LOGGER.errorf(ex, "Creating queue %s on node UP %s failed", ExternalJMSQueueService.this.queueName, member.getLive().toJson());
                                throw new RuntimeException(ex);
                            }
                            if (member.getBackup() != null) {
                                try {
                                    factory = new ActiveMQConnectionFactory(false, new TransportConfiguration[]{member.getBackup()});
                                    throwable = null;
                                    try {
                                        MessagingLogger.ROOT_LOGGER.infof("Creating queue %s on backup node UP %s - %s", ExternalJMSQueueService.this.queueName, member.getNodeId(), member.getBackup().toJson());
                                        ExternalJMSQueueService.this.config.createQueue((ConnectionFactory)factory, managementQueue, ExternalJMSQueueService.this.queueName);
                                    }
                                    catch (Throwable throwable4) {
                                        throwable = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (factory != null) {
                                            if (throwable != null) {
                                                try {
                                                    factory.close();
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable.addSuppressed(throwable5);
                                                }
                                            } else {
                                                factory.close();
                                            }
                                        }
                                    }
                                }
                                catch (JMSException | StartException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        }

                        public void nodeDown(long eventUID, String nodeID) {
                        }
                    };
                    locator.addClusterTopologyListener(listener);
                    Collection members = locator.getTopology().getMembers();
                    if (members == null || members.isEmpty()) {
                        this.config.createQueue(cf, managementQueue, this.queueName);
                    }
                } else {
                    this.config.createQueue(cf, managementQueue, this.queueName);
                }
            }
            catch (Exception ex) {
                MessagingLogger.ROOT_LOGGER.errorf(ex, "Error starting the external queue service %s", ex.getMessage());
                throw new StartException((Throwable)ex);
            }
            finally {
                try {
                    storeBaseContext.close();
                }
                catch (NamingException ex) {
                    throw new StartException((Throwable)ex);
                }
            }
        }
        this.queue = ActiveMQJMSClient.createQueue((String)this.queueName);
    }

    public synchronized void stop(StopContext context) {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
    }

    public Queue getValue() throws IllegalStateException, IllegalArgumentException {
        return this.queue;
    }

    public static Service<Queue> installService(String name, ServiceTarget serviceTarget, ServiceName serviceName) {
        ExternalJMSQueueService service = new ExternalJMSQueueService(name);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        serviceBuilder.install();
        return service;
    }

    public static Service<Queue> installRuntimeQueueService(DestinationConfiguration config, ServiceTarget serviceTarget, ServiceName pcf) {
        ExternalJMSQueueService service = new ExternalJMSQueueService(config);
        ServiceBuilder serviceBuilder = serviceTarget.addService(config.getDestinationServiceName(), (Service)service);
        serviceBuilder.addDependency(NamingService.SERVICE_NAME, NamingStore.class, service.namingStoreInjector);
        serviceBuilder.addDependency(pcf, ExternalPooledConnectionFactoryService.class, service.pcfInjector);
        serviceBuilder.addDependencies(new ServiceName[]{ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{config.getResourceAdapter()})});
        serviceBuilder.install();
        return service;
    }
}

