/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.git;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.jboss.as.server.logging.ServerLogger;

public class GitRepositoryConfiguration {
    private final Path basePath;
    private final String repository;
    private final String branch;
    private final URI authenticationConfig;
    private final Set<String> ignored;

    private GitRepositoryConfiguration(Path basePath, String repository, String branch, URI authenticationConfig, Set<String> ignored) {
        this.basePath = basePath;
        this.repository = repository;
        this.branch = branch;
        this.authenticationConfig = authenticationConfig;
        this.ignored = ignored;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getBranch() {
        return this.branch;
    }

    public URI getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public Set<String> getIgnored() {
        return this.ignored;
    }

    public boolean isLocal() {
        return "local".equals(this.repository);
    }

    public static class Builder {
        private Path basePath;
        private String repository;
        private String branch = "master";
        private URI authenticationConfig;
        private Set<String> ignored;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public Builder setBasePath(Path basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setBranch(String branch) {
            if (branch != null) {
                this.branch = branch;
            }
            return this;
        }

        public Builder setAuthenticationConfig(URI authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
            return this;
        }

        public Builder setAuthenticationConfig(String authConfiguration) {
            if (authConfiguration != null) {
                try {
                    this.authenticationConfig = new URI(authConfiguration);
                }
                catch (URISyntaxException ex) {
                    ServerLogger.ROOT_LOGGER.errorUsingGit(ex, ex.getMessage());
                }
            }
            return this;
        }

        public Builder setIgnored(Set<String> ignored) {
            this.ignored = ignored;
            return this;
        }

        public GitRepositoryConfiguration build() {
            if (this.repository == null || this.repository.isEmpty()) {
                if (Files.exists(this.basePath.resolve(".git"), new LinkOption[0])) {
                    this.repository = "local";
                } else {
                    return null;
                }
            }
            if (this.ignored == null) {
                this.ignored = Collections.emptySet();
            }
            return new GitRepositoryConfiguration(this.basePath, this.repository, this.branch, this.authenticationConfig, this.ignored);
        }
    }
}

