/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import org.jboss.as.controller.client.helpers.MeasurementUnit;

public class UnitConverter {
    static double scaleToBase(double initialValue, MeasurementUnit unit) {
        double ratio;
        if (unit == null) {
            return initialValue;
        }
        switch (unit) {
            case BITS: {
                ratio = 0.0;
                break;
            }
            case KILOBITS: {
                ratio = 125.0;
                break;
            }
            case MEGABITS: {
                ratio = 125000.0;
                break;
            }
            case GIGABITS: {
                ratio = 1.25E8;
                break;
            }
            case TERABITS: {
                ratio = 1.25E11;
                break;
            }
            case PETABITS: {
                ratio = 1.25E14;
                break;
            }
            case KILOBYTES: {
                ratio = 1000.0;
                break;
            }
            case MEGABYTES: {
                ratio = 1000000.0;
                break;
            }
            case GIGABYTES: {
                ratio = 1.0E9;
                break;
            }
            case TERABYTES: {
                ratio = 1.0E12;
                break;
            }
            case PETABYTES: {
                ratio = 1.0E15;
                break;
            }
            case NANOSECONDS: {
                ratio = 1.0E-9;
                break;
            }
            case MICROSECONDS: {
                ratio = 1.0E-6;
                break;
            }
            case MILLISECONDS: 
            case EPOCH_MILLISECONDS: {
                ratio = 0.001;
                break;
            }
            case MINUTES: {
                ratio = 60.0;
                break;
            }
            case HOURS: {
                ratio = 3600.0;
                break;
            }
            case DAYS: {
                ratio = 86400.0;
                break;
            }
            default: {
                ratio = 1.0;
            }
        }
        return initialValue * ratio;
    }

    static String unitSuffix(MeasurementUnit unit) {
        if (unit == null) {
            return "";
        }
        switch (unit) {
            case BITS: 
            case KILOBITS: 
            case MEGABITS: 
            case GIGABITS: 
            case TERABITS: 
            case PETABITS: 
            case KILOBYTES: 
            case MEGABYTES: 
            case GIGABYTES: 
            case TERABYTES: 
            case PETABYTES: 
            case BYTES: {
                return "_bytes";
            }
            case NANOSECONDS: 
            case MICROSECONDS: 
            case MILLISECONDS: 
            case EPOCH_MILLISECONDS: 
            case MINUTES: 
            case HOURS: 
            case DAYS: 
            case EPOCH_SECONDS: 
            case SECONDS: {
                return "_seconds";
            }
        }
        return "";
    }
}

