/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.VFSLogger;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VFSUtils;

public final class TempFileProvider
implements Closeable {
    private static final String JBOSS_TMP_DIR_PROPERTY = "jboss.server.temp.dir";
    private static final String JVM_TMP_DIR_PROPERTY = "java.io.tmpdir";
    private static final File TMP_ROOT;
    private static final int RETRIES = 10;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final File providerRoot;
    private final ScheduledExecutorService executor;
    private static final Random rng;

    public static TempFileProvider create(String providerType, ScheduledExecutorService executor) throws IOException {
        return TempFileProvider.create(providerType, executor, false);
    }

    public static TempFileProvider create(String providerType, ScheduledExecutorService executor, boolean cleanExisting) throws IOException {
        if (cleanExisting) {
            try {
                File possiblyExistingProviderRoot = new File(TMP_ROOT, providerType);
                if (possiblyExistingProviderRoot.exists()) {
                    File toBeDeletedProviderRoot = new File(TMP_ROOT, TempFileProvider.createTempName(providerType + "-to-be-deleted-", ""));
                    boolean renamed = possiblyExistingProviderRoot.renameTo(toBeDeletedProviderRoot);
                    if (!renamed) {
                        throw new IOException("Failed to rename " + possiblyExistingProviderRoot.getAbsolutePath() + " to " + toBeDeletedProviderRoot.getAbsolutePath());
                    }
                    executor.submit(new DeleteTask(toBeDeletedProviderRoot, executor));
                }
            }
            catch (Throwable t) {
                VFSLogger.ROOT_LOGGER.failedToCleanExistingContentForTempFileProvider(providerType);
                VFSLogger.ROOT_LOGGER.debug("Failed to clean existing content for temp file provider of type " + providerType, t);
            }
        }
        File providerRoot = new File(TMP_ROOT, providerType);
        return new TempFileProvider(TempFileProvider.createTempDir(providerType, "", providerRoot), executor);
    }

    File getProviderRoot() {
        return this.providerRoot;
    }

    private TempFileProvider(File providerRoot, ScheduledExecutorService executor) {
        this.providerRoot = providerRoot;
        this.executor = executor;
    }

    public TempDir createTempDir(String originalName) throws IOException {
        if (!this.open.get()) {
            throw VFSMessages.MESSAGES.tempFileProviderClosed();
        }
        String name = TempFileProvider.createTempName(originalName + "-", "");
        File f = new File(this.providerRoot, name);
        for (int i = 0; i < 10; ++i) {
            if (!f.mkdirs()) continue;
            return new TempDir(this, f);
        }
        throw VFSMessages.MESSAGES.couldNotCreateDirectory(originalName, 10);
    }

    private static File createTempDir(String prefix, String suffix, File root) throws IOException {
        for (int i = 0; i < 10; ++i) {
            File f = new File(root, TempFileProvider.createTempName(prefix, suffix));
            if (!f.mkdirs()) continue;
            if (f.isDirectory() && f.getParent() != null) {
                f.delete();
            }
            return f;
        }
        throw VFSMessages.MESSAGES.couldNotCreateDirectoryForRoot(root, prefix, suffix, 10);
    }

    static String createTempName(String prefix, String suffix) {
        return prefix + Long.toHexString(rng.nextLong()) + suffix;
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.delete(this.providerRoot);
        }
    }

    protected void finalize() {
        VFSUtils.safeClose((Closeable)this);
    }

    void delete(File root) throws IOException {
        new DeleteTask(root, this.executor).run();
    }

    static {
        String configTmpDir = System.getProperty(JBOSS_TMP_DIR_PROPERTY);
        if (configTmpDir == null) {
            configTmpDir = System.getProperty(JVM_TMP_DIR_PROPERTY);
        }
        try {
            TMP_ROOT = new File(configTmpDir, "vfs");
            TMP_ROOT.mkdirs();
        }
        catch (Exception e) {
            throw VFSMessages.MESSAGES.cantSetupTempFileProvider(e);
        }
        rng = new Random();
    }

    static final class DeleteTask
    implements Runnable {
        private final File root;
        private ScheduledExecutorService retryExecutor;

        DeleteTask(File root, ScheduledExecutorService retryExecutor) {
            this.root = root;
            this.retryExecutor = retryExecutor;
        }

        @Override
        public void run() {
            if (!VFSUtils.recursiveDelete(this.root)) {
                if (this.retryExecutor != null) {
                    VFSLogger.ROOT_LOGGER.tracef("Failed to delete root (%s), retrying in 30sec.", (Object)this.root);
                    this.retryExecutor.schedule(this, 30L, TimeUnit.SECONDS);
                } else {
                    VFSLogger.ROOT_LOGGER.tracef("Failed to delete root (%s).", (Object)this.root);
                }
            }
        }
    }
}

