/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.Tuple;

public class LOCAL_PING
extends Discovery {
    protected static final Map<String, List<PingData>> discovery = new ConcurrentHashMap<String, List<PingData>>();
    protected static final Function<String, List<PingData>> func = k -> new ArrayList();

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void stop() {
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        ++this.num_discovery_requests;
        List<PingData> list = discovery.get(this.cluster_name);
        if (list != null && !list.isEmpty()) {
            LOCAL_PING lOCAL_PING = this;
            synchronized (lOCAL_PING) {
                if (list.stream().noneMatch(PingData::isCoord)) {
                    list.get(0).coord(true);
                }
                list.stream().filter(el -> !el.sender.equals(this.local_addr)).forEach(d -> {
                    this.addAddressToLocalCache(d.sender, d.physical_addr);
                    responses.addResponse((PingData)d, false);
                });
            }
        }
        responses.done();
    }

    @Override
    public Object down(Event evt) {
        List<PingData> data;
        if (evt.type() == 6 && this.cluster_name != null && (data = discovery.get(this.cluster_name)) != null && !data.isEmpty()) {
            for (PingData d : data) {
                Address sender = d.getAddress();
                if (this.down_prot.down(new Event(87, sender)) != null) continue;
                this.down_prot.down(new Event(89, new Tuple<Address, PhysicalAddress>(sender, d.getPhysicalAddr())));
            }
        }
        return super.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnect() {
        if (this.cluster_name == null || this.local_addr == null) {
            throw new IllegalStateException("cluster name and local address cannot be null");
        }
        String logical_name = NameCache.get(this.local_addr);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        if (physical_addr != null) {
            PingData data = new PingData(this.local_addr, this.is_server, logical_name, physical_addr);
            List<PingData> list = discovery.computeIfAbsent(this.cluster_name, func);
            LOCAL_PING lOCAL_PING = this;
            synchronized (lOCAL_PING) {
                if (list.isEmpty()) {
                    data.coord(true);
                }
                list.add(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDisconnect() {
        if (this.local_addr == null || this.cluster_name == null) {
            return;
        }
        List<PingData> list = discovery.get(this.cluster_name);
        if (list != null) {
            LOCAL_PING lOCAL_PING = this;
            synchronized (lOCAL_PING) {
                list.removeIf(p -> this.local_addr.equals(p.getAddress()));
                if (list.isEmpty()) {
                    discovery.remove(this.cluster_name);
                }
            }
        }
    }

    public String toString() {
        return String.format("%s(%s)", LOCAL_PING.class.getSimpleName(), this.local_addr);
    }

    protected void addAddressToLocalCache(Address addr, PhysicalAddress phys_addr) {
        Tuple<Address, PhysicalAddress> tuple = new Tuple<Address, PhysicalAddress>(addr, phys_addr);
        this.down_prot.down(new Event(89, tuple));
    }
}

