/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.common.net.URIs;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.client.MatchUserRule;

class MatchNoUserRule
extends MatchRule {
    MatchNoUserRule(MatchRule parent) {
        super(parent.without(MatchUserRule.class));
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        String userInfo = URIs.getUserFromURI((URI)uri);
        return userInfo == null && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchNoUserRule(newParent);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return other.getMatchUser() == null && this.parentHalfEqual(other);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)3121, (int)0);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("no user,");
    }
}

