/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;
import org.jboss.ejb.protocol.remote.RemotingEJBDiscoveryProvider;

public final class RemoteTransportProvider
implements EJBTransportProvider {
    static final AttachmentKey<RemoteEJBReceiver> ATTACHMENT_KEY = new AttachmentKey();

    @Override
    public void notifyRegistered(EJBReceiverContext receiverContext) {
        EJBClientContext clientContext = receiverContext.getClientContext();
        clientContext.putAttachmentIfAbsent(ATTACHMENT_KEY, new RemoteEJBReceiver(this, receiverContext, new RemotingEJBDiscoveryProvider()));
    }

    @Override
    public boolean supportsProtocol(String uriScheme) {
        switch (uriScheme) {
            case "remote": 
            case "remote+http": 
            case "remote+https": 
            case "remoting": 
            case "http-remoting": 
            case "https-remoting": {
                return true;
            }
        }
        return false;
    }

    @Override
    public EJBReceiver getReceiver(EJBReceiverContext receiverContext, String uriScheme) throws IllegalArgumentException {
        switch (uriScheme) {
            case "remote": 
            case "remote+http": 
            case "remote+https": 
            case "remoting": 
            case "http-remoting": 
            case "https-remoting": {
                RemoteEJBReceiver receiver = receiverContext.getClientContext().getAttachment(ATTACHMENT_KEY);
                if (receiver == null) break;
                return receiver;
            }
        }
        throw new IllegalArgumentException("Unsupported EJB receiver protocol " + uriScheme);
    }
}

