/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.management.ActiveMQComponentControl;
import org.apache.activemq.artemis.api.core.management.Attribute;

public interface BridgeControl
extends ActiveMQComponentControl {
    @Attribute(desc="name of this bridge")
    public String getName();

    @Attribute(desc="name of the queue this bridge is consuming messages from")
    public String getQueueName();

    @Attribute(desc="address this bridge will forward messages to")
    public String getForwardingAddress();

    @Attribute(desc="filter string associated with this bridge")
    public String getFilterString();

    @Attribute(desc="name of the org.apache.activemq.artemis.core.server.cluster.Transformer implementation associated with this bridge")
    public String getTransformerClassName();

    @Attribute(desc="map of key, value pairs used to configure the transformer in JSON form")
    public String getTransformerPropertiesAsJSON() throws Exception;

    @Attribute(desc="map of key, value pairs used to configure the transformer")
    public Map<String, String> getTransformerProperties() throws Exception;

    @Attribute(desc="list of static connectors used by this bridge")
    public String[] getStaticConnectors() throws Exception;

    @Attribute(desc="name of the discovery group used by this bridge")
    public String getDiscoveryGroupName();

    @Attribute(desc="retry interval used by this bridge")
    public long getRetryInterval();

    @Attribute(desc="retry interval multiplier used by this bridge")
    public double getRetryIntervalMultiplier();

    @Attribute(desc="number of reconnection attempts used by this bridge")
    public int getReconnectAttempts();

    @Attribute(desc="whether this bridge is using duplicate detection")
    public boolean isUseDuplicateDetection();

    @Attribute(desc="whether this bridge is using high availability")
    public boolean isHA();

    @Attribute(desc="The messagesPendingAcknowledgement counter is incremented when the bridge is has forwarded a message but is waiting acknowledgement from the remote broker.")
    public long getMessagesPendingAcknowledgement();

    @Attribute(desc="The messagesAcknowledged counter is the number of messages actually received by the remote broker.")
    public long getMessagesAcknowledged();

    @Attribute(desc="The metrics for this bridge. The messagesPendingAcknowledgement counter is incremented when the bridge is has forwarded a message but is waiting acknowledgement from the remote broker. The messagesAcknowledged counter is the number of messages actually received by the remote broker.")
    public Map<String, Object> getMetrics();
}

