/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.EnumSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.access.Action;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.dmr.ModelNode;

public abstract class ServerProcessHandlers
implements OperationStepHandler {
    final ServerInventory serverInventory;

    ServerProcessHandlers(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String serverName = context.getCurrentAddressValue();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        ServerProcessHandlers.this.doExecute(serverName);
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }

    abstract void doExecute(String var1);

    public static class ServerKillHandler
    extends ServerProcessHandlers {
        public ServerKillHandler(ServerInventory serverInventory) {
            super(serverInventory);
        }

        @Override
        void doExecute(String serverName) {
            this.serverInventory.killServer(serverName);
        }
    }

    public static class ServerDestroyHandler
    extends ServerProcessHandlers {
        public ServerDestroyHandler(ServerInventory serverInventory) {
            super(serverInventory);
        }

        @Override
        void doExecute(String serverName) {
            this.serverInventory.destroyServer(serverName);
        }
    }
}

