/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ExpirationTracker<I> {
    private final long timeout;
    private final Map<I, ExpirationInfo> trackedIds;
    private ExpirationInfo firstExpiration;
    private ExpirationInfo lastExpiration;

    ExpirationTracker(Duration timeout) {
        this.timeout = timeout.toMillis();
        this.trackedIds = new HashMap<I, ExpirationInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackExpiration(I id) {
        ExpirationInfo expiration;
        Object object = this;
        synchronized (object) {
            if (this.trackedIds.containsKey(id)) {
                expiration = this.trackedIds.get(id);
                if (expiration != this.lastExpiration) {
                    if (expiration.nextExpiration != null) {
                        expiration.nextExpiration.previousExpiration = expiration.previousExpiration;
                    }
                    if (expiration.previousExpiration != null) {
                        expiration.previousExpiration.nextExpiration = expiration.nextExpiration;
                    } else if (this.firstExpiration == expiration) {
                        this.firstExpiration = this.firstExpiration.nextExpiration;
                    }
                    expiration.previousExpiration = null;
                    expiration.nextExpiration = null;
                }
            } else {
                expiration = new ExpirationInfo(id);
                this.trackedIds.put(id, expiration);
            }
            if (this.lastExpiration == null) {
                this.firstExpiration = this.lastExpiration = expiration;
            } else if (this.lastExpiration != expiration) {
                expiration.previousExpiration = this.lastExpiration;
                this.lastExpiration.nextExpiration = expiration;
                this.lastExpiration = expiration;
            }
        }
        object = expiration;
        synchronized (object) {
            expiration.expiration = System.currentTimeMillis() + this.timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateExpiration(I id) {
        ExpirationTracker expirationTracker = this;
        synchronized (expirationTracker) {
            if (this.trackedIds.containsKey(id)) {
                ExpirationInfo expiration;
                ExpirationInfo expirationInfo = expiration = this.trackedIds.get(id);
                synchronized (expirationInfo) {
                    expiration.expiration = -1L;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retryExpiration(I id) {
        ExpirationTracker expirationTracker = this;
        synchronized (expirationTracker) {
            ExpirationInfo expirationInfo;
            if (this.trackedIds.containsKey(id)) {
                return;
            }
            ExpirationInfo expirationInfo2 = expirationInfo = new ExpirationInfo(id);
            synchronized (expirationInfo2) {
                expirationInfo.expiration = 0L;
            }
            expirationInfo.nextExpiration = this.firstExpiration;
            if (this.firstExpiration != null) {
                this.firstExpiration.previousExpiration = expirationInfo;
            }
            this.firstExpiration = expirationInfo;
            if (this.lastExpiration == null) {
                this.lastExpiration = expirationInfo;
            }
            this.trackedIds.put(id, expirationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forget(I id) {
        ExpirationTracker expirationTracker = this;
        synchronized (expirationTracker) {
            if (!this.trackedIds.containsKey(id)) {
                return;
            }
            ExpirationInfo expirationInfo = this.trackedIds.remove(id);
            if (expirationInfo.previousExpiration != null) {
                expirationInfo.previousExpiration.nextExpiration = expirationInfo.nextExpiration;
            }
            if (expirationInfo.nextExpiration != null) {
                expirationInfo.nextExpiration.previousExpiration = expirationInfo.previousExpiration;
            }
            if (this.firstExpiration == expirationInfo) {
                this.firstExpiration = expirationInfo.nextExpiration;
            }
            if (this.lastExpiration == expirationInfo) {
                this.lastExpiration = expirationInfo.previousExpiration;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    I getExpiredId(long currentTimeInMillis) {
        ExpirationTracker expirationTracker = this;
        synchronized (expirationTracker) {
            ExpirationInfo expiration = this.firstExpiration;
            while (expiration != null && this.readExpiration(expiration) == -1L) {
                expiration = expiration.nextExpiration;
            }
            if (expiration != null && this.readExpiration(expiration) <= currentTimeInMillis) {
                Object expiredId = expiration.id;
                if (expiration.previousExpiration != null) {
                    expiration.previousExpiration.nextExpiration = expiration.nextExpiration;
                }
                if (expiration.nextExpiration != null) {
                    expiration.nextExpiration.previousExpiration = expiration.previousExpiration;
                }
                if (this.firstExpiration == expiration) {
                    this.firstExpiration = expiration.nextExpiration;
                }
                if (this.lastExpiration == expiration) {
                    this.lastExpiration = expiration.previousExpiration;
                }
                this.trackedIds.remove(expiredId);
                return expiredId;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readExpiration(ExpirationInfo info) {
        ExpirationInfo expirationInfo = info;
        synchronized (expirationInfo) {
            return info.expiration;
        }
    }

    Collection<I> getTrackedIds() {
        return Collections.unmodifiableSet(this.trackedIds.keySet());
    }

    synchronized long getNextExpirationInMillis() {
        ExpirationInfo firstExpiration = this.firstExpiration;
        long expiration = -1L;
        while (firstExpiration != null && (expiration = this.readExpiration(firstExpiration)) == -1L) {
            firstExpiration = firstExpiration.nextExpiration;
        }
        return expiration;
    }

    private class ExpirationInfo {
        ExpirationInfo nextExpiration;
        ExpirationInfo previousExpiration;
        volatile long expiration;
        final I id;

        ExpirationInfo(I id) {
            this.id = id;
        }
    }
}

