/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.orm.jmx.impl;

import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.jmx.IndexControlMBean;
import org.hibernate.search.spi.IndexedTypeIdentifier;

public class IndexControl
implements IndexControlMBean {
    private final SessionFactory hibernateSessionFactory;
    private final ExtendedSearchIntegrator extendedIntegrator;
    private int batchSize = 25;
    private int numberOfObjectLoadingThreads = 2;
    private int numberOfFetchingThreads = 4;

    public IndexControl(ExtendedSearchIntegrator extendedIntegrator, SessionFactory factory) {
        this.extendedIntegrator = extendedIntegrator;
        this.hibernateSessionFactory = factory;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setNumberOfObjectLoadingThreads(int numberOfThreads) {
        this.numberOfObjectLoadingThreads = numberOfThreads;
    }

    public int getNumberOfObjectLoadingThreads() {
        return this.numberOfObjectLoadingThreads;
    }

    public void setNumberOfFetchingThreads(int numberOfThreads) {
        this.numberOfFetchingThreads = numberOfThreads;
    }

    public int getNumberOfFetchingThreads() {
        return this.numberOfFetchingThreads;
    }

    public void index(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        try (Session session = this.hibernateSessionFactory.openSession();){
            FullTextSession fulltextSession = Search.getFullTextSession(session);
            fulltextSession.createIndexer(new Class[]{clazz}).batchSizeToLoadObjects(this.batchSize).cacheMode(CacheMode.NORMAL).threadsToLoadObjects(this.numberOfObjectLoadingThreads).startAndWait();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SearchException("Unable to complete indexing");
        }
    }

    public void optimize(String entity) {
        IndexedTypeIdentifier typeIdentifier = this.extendedIntegrator.getIndexBindings().keyFromName(entity);
        this.extendedIntegrator.optimize(typeIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        try (Session session = this.hibernateSessionFactory.openSession();){
            boolean controlTransactions;
            FullTextSession fullTextSession = Search.getFullTextSession(session);
            Transaction transaction = ((SessionImplementor)session).accessTransaction();
            boolean bl = controlTransactions = !transaction.isActive();
            if (controlTransactions) {
                transaction.begin();
            }
            try {
                fullTextSession.purgeAll(clazz);
            }
            finally {
                if (controlTransactions) {
                    transaction.commit();
                }
            }
        }
    }

    private Class<?> getEntityClass(String entity) {
        Class clazz;
        ClassLoaderService classLoaderService = this.extendedIntegrator.getServiceManager().getClassLoaderService();
        try {
            clazz = classLoaderService.classForName(entity);
        }
        catch (ClassLoadingException e) {
            throw new IllegalArgumentException(entity + " not a indexed entity");
        }
        return clazz;
    }
}

