/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.dispatcher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Node;

public interface CommandDispatcher<C>
extends AutoCloseable {
    public C getContext();

    public <R> CompletionStage<R> executeOnMember(Command<R, ? super C> var1, Node var2) throws CommandDispatcherException;

    public <R> Map<Node, CompletionStage<R>> executeOnGroup(Command<R, ? super C> var1, Node ... var2) throws CommandDispatcherException;

    @Deprecated
    default public <R> CommandResponse<R> executeOnNode(Command<R, ? super C> command, Node node) throws CommandDispatcherException {
        try {
            return CommandResponse.of(this.executeOnMember(command, node).toCompletableFuture().join());
        }
        catch (CompletionException e) {
            return CommandResponse.of(e);
        }
    }

    @Deprecated
    default public <R> Map<Node, CommandResponse<R>> executeOnCluster(Command<R, ? super C> command, Node ... excludedNodes) throws CommandDispatcherException {
        HashMap<Node, CommandResponse<R>> result = new HashMap<Node, CommandResponse<R>>();
        for (Map.Entry<Node, CompletionStage<R>> entry : this.executeOnGroup(command, excludedNodes).entrySet()) {
            try {
                result.put(entry.getKey(), CommandResponse.of(entry.getValue().toCompletableFuture().join()));
            }
            catch (CancellationException cancellationException) {
            }
            catch (CompletionException e) {
                result.put(entry.getKey(), CommandResponse.of(e));
            }
        }
        return result;
    }

    @Deprecated
    default public <R> Future<R> submitOnNode(Command<R, ? super C> command, Node node) throws CommandDispatcherException {
        return this.executeOnMember(command, node).toCompletableFuture();
    }

    @Deprecated
    default public <R> Map<Node, Future<R>> submitOnCluster(Command<R, ? super C> command, Node ... excludedNodes) throws CommandDispatcherException {
        return this.executeOnGroup(command, excludedNodes);
    }

    @Override
    public void close();
}

