/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.deployment;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.wildfly.extension.picketlink.federation.deployment.FederationDependencyProcessor;
import org.wildfly.extension.picketlink.federation.service.PicketLinkFederationService;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class FederationDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final Phase PHASE = Phase.INSTALL;
    public static final int PRIORITY = 1;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        PicketLinkFederationService federationService = (PicketLinkFederationService)deploymentUnit.getAttachment(FederationDependencyProcessor.DEPLOYMENT_ATTACHMENT_KEY);
        if (federationService != null) {
            PicketLinkLogger.ROOT_LOGGER.federationConfiguringDeployment(deploymentUnit.getName());
            federationService.configure(deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

