/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate5.service;

import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.spi.ServiceContributor;
import org.jboss.as.jpa.hibernate5.JpaLogger;
import org.jboss.as.jpa.hibernate5.service.WildFlyCustomJtaPlatformInitiator;
import org.jboss.as.jpa.hibernate5.service.WildFlyCustomRegionFactoryInitiator;

public class ServiceContributorImpl
implements ServiceContributor {
    private static final String CONTROLJTAINTEGRATION = "wildfly.jpa.jtaplatform";
    private static final String CONTROL2LCINTEGRATION = "wildfly.jpa.regionfactory";
    private static final String TRANSACTION_PLATFORM = "hibernate.transaction.jta.platform";
    private static final String EHCACHE = "ehcache";
    private static final String HIBERNATE_REGION_FACTORY_CLASS = "hibernate.cache.region.factory_class";

    public void contribute(StandardServiceRegistryBuilder serviceRegistryBuilder) {
        Boolean jtaPlatformInitiatorEnabled = serviceRegistryBuilder.getSettings().getOrDefault(CONTROLJTAINTEGRATION, true);
        if (serviceRegistryBuilder.getSettings().get(TRANSACTION_PLATFORM) != null) {
            JpaLogger.JPA_LOGGER.tracef("ServiceContributorImpl#contribute application configured the JTA Platform to be used instead of WildFlyCustomJtaPlatform (%s=%s)", TRANSACTION_PLATFORM, serviceRegistryBuilder.getSettings().get(TRANSACTION_PLATFORM));
        } else if (jtaPlatformInitiatorEnabled == null || jtaPlatformInitiatorEnabled instanceof Boolean && jtaPlatformInitiatorEnabled.booleanValue() || Boolean.parseBoolean(((Object)jtaPlatformInitiatorEnabled).toString())) {
            JpaLogger.JPA_LOGGER.tracef("ServiceContributorImpl#contribute application will use WildFlyCustomJtaPlatform", new Object[0]);
            serviceRegistryBuilder.addInitiator((StandardServiceInitiator)new WildFlyCustomJtaPlatformInitiator());
        }
        Boolean regionFactoryInitiatorEnabled = serviceRegistryBuilder.getSettings().getOrDefault(CONTROL2LCINTEGRATION, true);
        Object regionFactory = serviceRegistryBuilder.getSettings().get(HIBERNATE_REGION_FACTORY_CLASS);
        if (regionFactory instanceof String && ((String)regionFactory).contains(EHCACHE)) {
            JpaLogger.JPA_LOGGER.tracef("ServiceContributorImpl#contribute application is using Ehcache via regionFactory=%s", regionFactory);
        } else if (regionFactoryInitiatorEnabled == null || regionFactoryInitiatorEnabled instanceof Boolean && regionFactoryInitiatorEnabled.booleanValue() || Boolean.parseBoolean(((Object)regionFactoryInitiatorEnabled).toString())) {
            JpaLogger.JPA_LOGGER.tracef("ServiceContributorImpl#contribute adding ORM initiator for 2lc region factory", new Object[0]);
            serviceRegistryBuilder.addInitiator((StandardServiceInitiator)new WildFlyCustomRegionFactoryInitiator());
        }
    }
}

