/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.annotations.repository.jandex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jca.common.annotations.repository.jandex.AnnotationImpl;
import org.jboss.jca.common.spi.annotations.repository.Annotation;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;

public class AnnotationRepositoryImpl
implements AnnotationRepository {
    private Index backingRepository;
    private ClassLoader cl;

    public AnnotationRepositoryImpl(Index backingRepository, ClassLoader cl) {
        if (backingRepository == null) {
            throw new IllegalArgumentException("repository cannot be null");
        }
        this.backingRepository = backingRepository;
        this.cl = cl;
    }

    public Collection<Annotation> getAnnotation(Class<?> annotationClass) {
        List instances = this.backingRepository.getAnnotations(DotName.createSimple((String)annotationClass.getName()));
        ArrayList<AnnotationImpl> annotations = new ArrayList<AnnotationImpl>(instances.size());
        for (AnnotationInstance instance : instances) {
            AnnotationTarget target = instance.target();
            AnnotationImpl annotation = null;
            if (target instanceof MethodInfo) {
                MethodInfo m = (MethodInfo)target;
                ArrayList<String> parameterTypes = new ArrayList<String>(m.args().length);
                for (Type type : m.args()) {
                    parameterTypes.add(type.toString());
                }
                String declaringClass = m.declaringClass().name().toString();
                annotation = new AnnotationImpl(declaringClass, this.cl, parameterTypes, m.name(), true, false, annotationClass);
            } else if (target instanceof FieldInfo) {
                FieldInfo f = (FieldInfo)target;
                String declaringClass = f.declaringClass().name().toString();
                annotation = new AnnotationImpl(declaringClass, this.cl, null, f.name(), false, true, annotationClass);
            } else if (target instanceof ClassInfo) {
                ClassInfo c = (ClassInfo)target;
                annotation = new AnnotationImpl(c.name().toString(), this.cl, null, null, false, false, annotationClass);
            }
            if (annotation == null) continue;
            annotations.add(annotation);
        }
        annotations.trimToSize();
        if (annotations.size() == 0) {
            return null;
        }
        return Collections.unmodifiableList(annotations);
    }
}

