/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.singleton.AbstractDistributedSingletonService;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceContext;
import org.wildfly.clustering.server.singleton.LegacySingletonContext;
import org.wildfly.clustering.server.singleton.Lifecycle;
import org.wildfly.clustering.server.singleton.PrimaryProxyContext;
import org.wildfly.clustering.server.singleton.PrimaryProxyService;
import org.wildfly.clustering.server.singleton.ServiceLifecycle;
import org.wildfly.clustering.singleton.SingletonService;

@Deprecated
public class LegacyDistributedSingletonService<T>
extends AbstractDistributedSingletonService<LegacySingletonContext<T>>
implements SingletonService<T>,
LegacySingletonContext<T>,
PrimaryProxyContext<T> {
    private final ServiceName name;
    private volatile boolean started = false;
    private volatile ServiceController<T> primaryController;
    private volatile ServiceController<T> backupController;

    public LegacyDistributedSingletonService(DistributedSingletonServiceContext context, Service<T> primaryService, Service<T> backupService) {
        this(context, primaryService, backupService, new LazySupplier<PrimaryProxyContext<T>>());
    }

    private LegacyDistributedSingletonService(DistributedSingletonServiceContext context, Service<T> primaryService, Service<T> backupService, LazySupplier<PrimaryProxyContext<T>> contextFactory) {
        super(context, new ServiceLifecycleFactory<T>(context.getServiceName(), primaryService, backupService != null ? backupService : new PrimaryProxyService<T>(contextFactory)));
        contextFactory.accept(this);
        this.name = context.getServiceName();
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    @Override
    public LegacySingletonContext<T> get() {
        return this;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        ServiceContainer registry = context.getController().getServiceContainer();
        this.primaryController = registry.getService(this.getServiceName().append(new String[]{"primary"}));
        this.backupController = registry.getService(this.getServiceName().append(new String[]{"backup"}));
        this.started = true;
    }

    @Override
    public void stop(StopContext context) {
        this.started = false;
        super.stop(context);
    }

    public T getValue() {
        while (this.started) {
            try {
                return (T)(this.isPrimary() ? this.primaryController : this.backupController).getValue();
            }
            catch (IllegalStateException e) {
                if (this.getServiceProviderRegistration().getProviders().size() < this.getQuorum()) {
                    throw ClusteringServerLogger.ROOT_LOGGER.notStarted(this.getServiceName().getCanonicalName());
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw e;
                }
                Thread.yield();
            }
        }
        throw ClusteringServerLogger.ROOT_LOGGER.notStarted(this.getServiceName().getCanonicalName());
    }

    @Override
    public CommandDispatcher<LegacySingletonContext<T>> getCommandDispatcher() {
        return super.getCommandDispatcher();
    }

    @Override
    public Optional<T> getLocalValue() {
        try {
            return this.isPrimary() ? Optional.ofNullable(this.primaryController.getValue()) : null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private static class PrimaryBackupLifecycle
    implements Lifecycle {
        private final Lifecycle primaryLifecycle;
        private final Lifecycle backupLifecycle;

        PrimaryBackupLifecycle(Lifecycle primaryLifecycle, Lifecycle backupLifecycle) {
            this.primaryLifecycle = primaryLifecycle;
            this.backupLifecycle = backupLifecycle;
        }

        @Override
        public void start() {
            this.backupLifecycle.stop();
            this.primaryLifecycle.start();
        }

        @Override
        public void stop() {
            this.primaryLifecycle.stop();
            this.backupLifecycle.start();
        }
    }

    private static class ServiceLifecycleFactory<T>
    implements Function<ServiceTarget, Lifecycle> {
        private final ServiceName name;
        private final Service<T> primaryService;
        private final Service<T> backupService;

        ServiceLifecycleFactory(ServiceName name, Service<T> primaryService, Service<T> backupService) {
            this.name = name;
            this.primaryService = primaryService;
            this.backupService = backupService;
        }

        @Override
        public Lifecycle apply(ServiceTarget target) {
            ServiceLifecycle primaryLifecycle = new ServiceLifecycle(target.addService(this.name.append(new String[]{"primary"}), this.primaryService).setInitialMode(ServiceController.Mode.NEVER).install());
            ServiceLifecycle backupLifecycle = new ServiceLifecycle(target.addService(this.name.append(new String[]{"backup"}), this.backupService).setInitialMode(ServiceController.Mode.ACTIVE).install());
            return new PrimaryBackupLifecycle(primaryLifecycle, backupLifecycle);
        }
    }

    static class LazySupplier<T>
    implements Supplier<T>,
    Consumer<T> {
        private volatile T value;

        LazySupplier() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

