/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific;

import com.arjuna.ArjunaOTS.ArjunaFactoryPOA;
import com.arjuna.ArjunaOTS.GlobalTransactionInfo;
import com.arjuna.ArjunaOTS.TransactionInfo;
import com.arjuna.ArjunaOTS.TransactionType;
import com.arjuna.ArjunaOTS.UidCoordinator;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionManager;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.interposition.FactoryList;
import com.arjuna.ats.internal.jts.interposition.ServerFactory;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteHeuristicTransaction;
import com.arjuna.ats.internal.jts.utils.Helper;
import com.arjuna.ats.internal.jts.utils.TxStoreLog;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.otid_t;

public class TransactionFactoryImple
extends ArjunaFactoryPOA {
    private TransactionFactory _factoryRef;
    private static FactoryList creators = new FactoryList();

    public TransactionFactoryImple() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"TransactionFactoryImple::TransactionFactoryImple ()");
        }
        this._factoryRef = this.getReference();
    }

    public TransactionFactoryImple(String name) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TransactionFactoryImple::TransactionFactoryImple ( " + name + " )"));
        }
        this._factoryRef = this.getReference();
    }

    public final synchronized TransactionFactory getReference() {
        if (this._factoryRef == null) {
            ORBManager.getPOA().objectIsReady(this);
            this._factoryRef = TransactionFactoryHelper.narrow(ORBManager.getPOA().corbaReference(this));
        }
        return this._factoryRef;
    }

    @Override
    public Control create(int time_out) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TransactionFactoryImple::create ( " + time_out + " )"));
        }
        ControlImple tranControl = this.createLocal(time_out);
        return tranControl.getControl();
    }

    public ControlImple createLocal(int time_out) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TransactionFactoryImple::createLocal ( " + time_out + " )"));
        }
        try {
            ControlImple tranControl = new ControlImple((Control)null, (ArjunaTransactionImple)null);
            int theTimeout = time_out;
            if (theTimeout == 0) {
                theTimeout = TxControl.getDefaultTimeout();
            }
            if (theTimeout > 0) {
                TransactionReaper reaper = TransactionReaper.transactionReaper();
                reaper.insert(new ControlWrapper(tranControl), theTimeout);
            }
            return tranControl;
        }
        catch (OutOfMemoryError e) {
            System.gc();
            throw new NO_MEMORY(0, CompletionStatus.COMPLETED_NO);
        }
    }

    public ControlImple recreateLocal(PropagationContext ctx) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"TransactionFactoryImple::recreateLocal ()");
        }
        if (ctx.current.coord == null) {
            return null;
        }
        return FactoryList.recreateLocal(ctx, ctx.current.otid.formatID);
    }

    @Override
    public Control recreate(PropagationContext ctx) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"TransactionFactoryImple::recreate ()");
        }
        return this.recreateLocal(ctx).getControl();
    }

    public static Control create_subtransaction(Control control, ArjunaTransactionImple parent) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TransactionFactoryImple::create_subtransaction ( " + control + ", " + (parent != null ? parent.get_uid() : Uid.nullUid()) + " )"));
        }
        try {
            ControlImple subTranControl = new ControlImple(control, parent);
            return subTranControl.getControl();
        }
        catch (OutOfMemoryError e) {
            System.gc();
            throw new NO_MEMORY(0, CompletionStatus.COMPLETED_NO);
        }
    }

    public static Control createProxy(Coordinator coordinator, Terminator terminator) {
        return TransactionFactoryImple.createProxy(coordinator, terminator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Control createProxy(Coordinator coordinator, Terminator terminator, Control parentControl) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TransactionFactoryImple::createProxy ( " + coordinator + ", " + terminator + ", " + parentControl + " )"));
        }
        UidCoordinator uidCoord = Helper.getUidCoordinator(coordinator);
        Uid theUid = null;
        if (uidCoord != null) {
            block9: {
                try {
                    theUid = Helper.getUid(uidCoord);
                    if (ServerControl.allServerControls == null) break block9;
                    Hashtable hashtable = ServerControl.allServerControls;
                    synchronized (hashtable) {
                        ControlImple c = (ControlImple)ServerControl.allServerControls.get(theUid);
                        if (c != null) {
                            return c.getControl();
                        }
                    }
                }
                catch (Exception e) {
                    theUid = new Uid();
                }
            }
            uidCoord = null;
        } else {
            theUid = new Uid();
        }
        ControlImple proxy = new ControlImple(coordinator, terminator, parentControl, theUid);
        return proxy.getControl();
    }

    public static Control createPropagatedControl(Coordinator coord) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TransactionFactoryImple::createPropagatedControl ( " + coord + " )"));
        }
        ControlImple proxyControl = new ControlImple(coord, null);
        return proxyControl.getControl();
    }

    @Override
    public otid_t[] numberOfTransactions(TransactionType t) throws Inactive, NoTransaction, SystemException {
        switch (t.value()) {
            case 0: {
                return this.activeTransactions();
            }
            case 2: {
                return this.unresolvedTransactions();
            }
        }
        throw new BAD_OPERATION();
    }

    @Override
    public otid_t[] getChildTransactions(otid_t parent) throws Inactive, NoTransaction, SystemException {
        Uid u = Utility.otidToUid(parent);
        otid_t[] ctx = null;
        if (u == null) {
            throw new BAD_PARAM("otid_t " + jtsLogger.i18NLogger.get_orbspecific_otiderror());
        }
        BasicAction act = ActionManager.manager().get(u);
        if (act == null) {
            throw new NoTransaction();
        }
        if (act.status() == 0) {
            int size;
            Object[] children = act.childTransactions();
            int n = size = children == null ? 0 : children.length;
            if (size > 0) {
                ctx = new otid_t[size];
                for (int i = 0; i < size; ++i) {
                    ctx[i] = Utility.uidToOtid((Uid)children[i]);
                }
            }
        } else {
            throw new Inactive();
        }
        return ctx;
    }

    @Override
    public Status getCurrentStatus(otid_t txid) throws SystemException {
        Uid u = Utility.otidToUid(txid);
        if (u == null) {
            throw new BAD_PARAM("otid_t " + jtsLogger.i18NLogger.get_orbspecific_otiderror());
        }
        return this.getCurrentStatus(u);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getCurrentStatus(Uid u) throws SystemException {
        if (!u.valid()) {
            throw new BAD_PARAM();
        }
        try {
            ControlImple ctx = null;
            Hashtable hashtable = ControlImple.allControls;
            synchronized (hashtable) {
                ctx = (ControlImple)ControlImple.allControls.get(u);
            }
            if (ctx != null) {
                return ctx.getImplHandle().get_status();
            }
            Status s = this.getOSStatus(u);
            if (s == Status.StatusUnknown || s == Status.StatusNoTransaction) {
                return ServerFactory.getCurrentStatus(u);
            }
            return s;
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_orbspecific_tficaught("TransactionFactoryImple.getCurrentStatus", u, e);
            return Status.StatusUnknown;
        }
    }

    @Override
    public Status getStatus(otid_t txid) throws NoTransaction, SystemException {
        Uid u = Utility.otidToUid(txid);
        if (u == null) {
            throw new BAD_PARAM("otid_t " + jtsLogger.i18NLogger.get_orbspecific_otiderror());
        }
        return this.getStatus(u);
    }

    public Status getStatus(Uid u) throws NoTransaction, SystemException {
        Status s = Status.StatusUnknown;
        try {
            s = this.getCurrentStatus(u);
        }
        catch (SystemException e2) {
            throw e2;
        }
        catch (Exception e3) {
            jtsLogger.i18NLogger.warn_orbspecific_tficaught("TransactionFactoryImple.getStatus", u, e3);
            return Status.StatusUnknown;
        }
        if (s == Status.StatusUnknown || s == Status.StatusNoTransaction) {
            return this.getOSStatus(u);
        }
        return s;
    }

    public Status getOSStatus(Uid u) throws NoTransaction, SystemException {
        Status s = Status.StatusUnknown;
        if (!u.valid()) {
            throw new BAD_PARAM();
        }
        RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
        try {
            int status = recoveryStore.currentState(u, ArjunaTransactionImple.typeName());
            switch (status) {
                case -1: {
                    Status heuristicStatus = this.getHeuristicStatus(u, recoveryStore);
                    if (Status.StatusNoTransaction.equals(heuristicStatus) || Status.StatusUnknown.equals(heuristicStatus)) {
                        return ServerFactory.getOSStatus(u);
                    }
                    return heuristicStatus;
                }
                case 1: {
                    return Status.StatusCommitted;
                }
                case 2: {
                    return Status.StatusPrepared;
                }
                case 4: 
                case 5: 
                case 6: {
                    return Status.StatusPrepared;
                }
            }
            return ServerFactory.getStatus(u);
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_orbspecific_tficaught("TransactionFactoryImple.getStatus", u, e);
            return Status.StatusUnknown;
        }
    }

    @Override
    public GlobalTransactionInfo getGlobalInfo() throws SystemException {
        GlobalTransactionInfo info = new GlobalTransactionInfo();
        info.totalNumberOfTransactions = (int)TxStats.getInstance().getNumberOfTransactions();
        info.numberOfCommittedTransactions = (int)TxStats.getInstance().getNumberOfCommittedTransactions();
        info.numberOfAbortedTransactions = (int)TxStats.getInstance().getNumberOfAbortedTransactions();
        info.averageLifetime = info.totalNumberOfTransactions > 0 ? (float)(TransactionReaper.transactionLifetime() / (long)info.totalNumberOfTransactions) : 0.0f;
        info.numberOfHeuristics = (int)TxStats.getInstance().getNumberOfHeuristics();
        TransactionReaper reaper = TransactionReaper.transactionReaper();
        info.reaperTimeout = reaper.checkingPeriod() == Long.MAX_VALUE ? 0 : (int)reaper.checkingPeriod();
        info.defaultTimeout = TxControl.getDefaultTimeout();
        return info;
    }

    @Override
    public TransactionInfo getTransactionInfo(otid_t txid) throws NoTransaction, SystemException {
        Uid u = Utility.otidToUid(txid);
        if (u == null) {
            throw new BAD_PARAM("otid_t " + jtsLogger.i18NLogger.get_orbspecific_otiderror());
        }
        return this.getTransactionInfo(u);
    }

    public TransactionInfo getTransactionInfo(Uid u) throws NoTransaction, SystemException {
        if (!u.valid()) {
            throw new BAD_PARAM(jtsLogger.i18NLogger.get_orbspecific_invaliduid() + " " + u);
        }
        try {
            Hashtable hashtable = ControlImple.allControls;
            synchronized (hashtable) {
                ControlImple ctx = (ControlImple)ControlImple.allControls.get(u);
                if (ctx != null) {
                    TransactionInfo info = new TransactionInfo();
                    info.currentDepth = ctx.getImplHandle().getHierarchy().depth();
                    TransactionReaper reaper = TransactionReaper.transactionReaper();
                    info.timeout = reaper.getTimeout(ctx);
                    info.numberOfThreads = ctx.getImplHandle().activeThreads();
                    return info;
                }
                throw new NoTransaction();
            }
        }
        catch (NoTransaction ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UNKNOWN();
        }
    }

    @Override
    public Control getTransaction(otid_t txid) throws NoTransaction, SystemException {
        Uid u = Utility.otidToUid(txid);
        if (u == null) {
            throw new BAD_PARAM("otid_t " + jtsLogger.i18NLogger.get_orbspecific_otiderror());
        }
        return this.getTransaction(u);
    }

    public Control getTransaction(Uid u) throws NoTransaction, SystemException {
        if (!u.valid()) {
            throw new BAD_PARAM();
        }
        try {
            Hashtable hashtable = ControlImple.allControls;
            synchronized (hashtable) {
                ControlImple ctx = (ControlImple)ControlImple.allControls.get(u);
                if (ctx != null) {
                    return ctx.getControl();
                }
                throw new NoTransaction();
            }
        }
        catch (NoTransaction ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UNKNOWN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final otid_t[] activeTransactions() throws Inactive, NoTransaction, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"TransactionFactoryImple::activeTransactions ()");
        }
        if (ControlImple.allControls == null) {
            throw new Inactive();
        }
        Hashtable hashtable = ControlImple.allControls;
        synchronized (hashtable) {
            if (ControlImple.allControls.size() == 0) {
                throw new NoTransaction();
            }
            otid_t[] ids = new otid_t[ControlImple.allControls.size()];
            Enumeration iter = ControlImple.allControls.elements();
            int i = 0;
            while (iter.hasMoreElements()) {
                ControlImple cont = (ControlImple)iter.nextElement();
                if (cont == null) continue;
                ids[i] = Utility.uidToOtid(cont.get_uid().stringForm());
                ++i;
            }
            return ids;
        }
    }

    private final otid_t[] unresolvedTransactions() throws Inactive, NoTransaction, SystemException {
        InputObjectState uids;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"TransactionFactoryImple::terminatedTransactions ()");
        }
        if (!TxStoreLog.getTransactions(uids = new InputObjectState(), 5)) {
            throw new NoTransaction();
        }
        Uid theUid = null;
        int count = 0;
        boolean finished = false;
        while (!finished) {
            try {
                theUid = UidHelper.unpackFrom(uids);
                if (theUid.equals(Uid.nullUid())) {
                    finished = true;
                    continue;
                }
                ++count;
            }
            catch (Exception e) {
                finished = true;
            }
        }
        otid_t[] ids = new otid_t[count];
        uids.reread();
        for (int i = 0; i < count; ++i) {
            try {
                theUid = UidHelper.unpackFrom(uids);
                ids[i] = Utility.uidToOtid(theUid.stringForm());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ids;
    }

    private Status getHeuristicStatus(Uid uid, RecoveryStore recoveryStore) throws ObjectStoreException {
        int status = recoveryStore.currentState(uid, AssumedCompleteHeuristicTransaction.typeName());
        switch (status) {
            case -1: {
                return Status.StatusNoTransaction;
            }
            case 1: {
                return Status.StatusCommitted;
            }
            case 2: {
                return Status.StatusPrepared;
            }
            case 4: 
            case 5: 
            case 6: {
                return Status.StatusPrepared;
            }
        }
        return Status.StatusUnknown;
    }
}

