/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.contact;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExpiredContactScanner
implements ExpiryScanner {
    private String _itemTypeName;
    private RecoveryStore _recoveryStore;
    private static final int _expiryTime = recoveryPropertyManager.getRecoveryEnvironmentBean().getTransactionStatusManagerExpiryTime() * 60 * 60;
    private static final SimpleDateFormat _timeFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");

    public ExpiredContactScanner() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("ExpiredContactScanner created, with expiry time of " + _expiryTime + " seconds"));
        }
        this._recoveryStore = StoreManager.getRecoveryStore();
        this._itemTypeName = FactoryContactItem.getTypeName();
    }

    @Override
    public void scan() {
        Date oldestSurviving = new Date(new Date().getTime() - (long)(_expiryTime * 1000));
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("ExpiredContactScanner - scanning to remove items from before " + _timeFormat.format(oldestSurviving)));
        }
        try {
            InputObjectState uids = new InputObjectState();
            if (this._recoveryStore.allObjUids(this._itemTypeName, uids)) {
                Uid theUid = null;
                boolean endOfUids = false;
                while (!endOfUids) {
                    Date timeOfDeath;
                    theUid = UidHelper.unpackFrom(uids);
                    if (theUid.equals(Uid.nullUid())) {
                        endOfUids = true;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    FactoryContactItem anItem = FactoryContactItem.recreate(newUid);
                    if (anItem == null || (timeOfDeath = anItem.getDeadTime()) == null || !timeOfDeath.before(oldestSurviving)) continue;
                    jtsLogger.i18NLogger.info_recovery_ExpiredContactScanner_3(newUid);
                    this._recoveryStore.remove_committed(newUid, this._itemTypeName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean toBeUsed() {
        return _expiryTime != 0;
    }
}

